// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ResponseMetadata model.
 */
@Fluent
public final class ResponseMetadata implements JsonSerializable<ResponseMetadata> {
    /*
     * Source of the Data
     */
    private DataSource dataSource;

    /**
     * Creates an instance of ResponseMetadata class.
     */
    public ResponseMetadata() {
    }

    /**
     * Get the dataSource property: Source of the Data.
     * 
     * @return the dataSource value.
     */
    public DataSource dataSource() {
        return this.dataSource;
    }

    /**
     * Set the dataSource property: Source of the Data.
     * 
     * @param dataSource the dataSource value to set.
     * @return the ResponseMetadata object itself.
     */
    public ResponseMetadata withDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (dataSource() != null) {
            dataSource().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataSource", this.dataSource);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ResponseMetadata from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ResponseMetadata if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ResponseMetadata.
     */
    public static ResponseMetadata fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ResponseMetadata deserializedResponseMetadata = new ResponseMetadata();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataSource".equals(fieldName)) {
                    deserializedResponseMetadata.dataSource = DataSource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedResponseMetadata;
        });
    }
}
