// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Application stack minor version.
 */
@Fluent
public final class StackMinorVersion implements JsonSerializable<StackMinorVersion> {
    /*
     * Application stack minor version (display only).
     */
    private String displayVersion;

    /*
     * Application stack minor version (runtime only).
     */
    private String runtimeVersion;

    /*
     * <code>true</code> if this is the default minor version; otherwise, <code>false</code>.
     */
    private Boolean isDefault;

    /*
     * <code>true</code> if this supports Remote Debugging, otherwise <code>false</code>.
     */
    private Boolean isRemoteDebuggingEnabled;

    /**
     * Creates an instance of StackMinorVersion class.
     */
    public StackMinorVersion() {
    }

    /**
     * Get the displayVersion property: Application stack minor version (display only).
     * 
     * @return the displayVersion value.
     */
    public String displayVersion() {
        return this.displayVersion;
    }

    /**
     * Set the displayVersion property: Application stack minor version (display only).
     * 
     * @param displayVersion the displayVersion value to set.
     * @return the StackMinorVersion object itself.
     */
    public StackMinorVersion withDisplayVersion(String displayVersion) {
        this.displayVersion = displayVersion;
        return this;
    }

    /**
     * Get the runtimeVersion property: Application stack minor version (runtime only).
     * 
     * @return the runtimeVersion value.
     */
    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    /**
     * Set the runtimeVersion property: Application stack minor version (runtime only).
     * 
     * @param runtimeVersion the runtimeVersion value to set.
     * @return the StackMinorVersion object itself.
     */
    public StackMinorVersion withRuntimeVersion(String runtimeVersion) {
        this.runtimeVersion = runtimeVersion;
        return this;
    }

    /**
     * Get the isDefault property: &lt;code&gt;true&lt;/code&gt; if this is the default minor version; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: &lt;code&gt;true&lt;/code&gt; if this is the default minor version; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param isDefault the isDefault value to set.
     * @return the StackMinorVersion object itself.
     */
    public StackMinorVersion withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the isRemoteDebuggingEnabled property: &lt;code&gt;true&lt;/code&gt; if this supports Remote Debugging,
     * otherwise &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isRemoteDebuggingEnabled value.
     */
    public Boolean isRemoteDebuggingEnabled() {
        return this.isRemoteDebuggingEnabled;
    }

    /**
     * Set the isRemoteDebuggingEnabled property: &lt;code&gt;true&lt;/code&gt; if this supports Remote Debugging,
     * otherwise &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param isRemoteDebuggingEnabled the isRemoteDebuggingEnabled value to set.
     * @return the StackMinorVersion object itself.
     */
    public StackMinorVersion withIsRemoteDebuggingEnabled(Boolean isRemoteDebuggingEnabled) {
        this.isRemoteDebuggingEnabled = isRemoteDebuggingEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("displayVersion", this.displayVersion);
        jsonWriter.writeStringField("runtimeVersion", this.runtimeVersion);
        jsonWriter.writeBooleanField("isDefault", this.isDefault);
        jsonWriter.writeBooleanField("isRemoteDebuggingEnabled", this.isRemoteDebuggingEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StackMinorVersion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StackMinorVersion if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the StackMinorVersion.
     */
    public static StackMinorVersion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StackMinorVersion deserializedStackMinorVersion = new StackMinorVersion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("displayVersion".equals(fieldName)) {
                    deserializedStackMinorVersion.displayVersion = reader.getString();
                } else if ("runtimeVersion".equals(fieldName)) {
                    deserializedStackMinorVersion.runtimeVersion = reader.getString();
                } else if ("isDefault".equals(fieldName)) {
                    deserializedStackMinorVersion.isDefault = reader.getNullable(JsonReader::getBoolean);
                } else if ("isRemoteDebuggingEnabled".equals(fieldName)) {
                    deserializedStackMinorVersion.isRemoteDebuggingEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStackMinorVersion;
        });
    }
}
