/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.HybridConnectionProperties;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

public final class HybridConnectionInner
extends ProxyOnlyResource {
    private HybridConnectionProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private HybridConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public HybridConnectionInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String serviceBusNamespace() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusNamespace();
    }

    public HybridConnectionInner withServiceBusNamespace(String serviceBusNamespace) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridConnectionProperties();
        }
        this.innerProperties().withServiceBusNamespace(serviceBusNamespace);
        return this;
    }

    public String relayName() {
        return this.innerProperties() == null ? null : this.innerProperties().relayName();
    }

    public HybridConnectionInner withRelayName(String relayName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridConnectionProperties();
        }
        this.innerProperties().withRelayName(relayName);
        return this;
    }

    public String relayArmUri() {
        return this.innerProperties() == null ? null : this.innerProperties().relayArmUri();
    }

    public HybridConnectionInner withRelayArmUri(String relayArmUri) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridConnectionProperties();
        }
        this.innerProperties().withRelayArmUri(relayArmUri);
        return this;
    }

    public String hostname() {
        return this.innerProperties() == null ? null : this.innerProperties().hostname();
    }

    public HybridConnectionInner withHostname(String hostname) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridConnectionProperties();
        }
        this.innerProperties().withHostname(hostname);
        return this;
    }

    public Integer port() {
        return this.innerProperties() == null ? null : this.innerProperties().port();
    }

    public HybridConnectionInner withPort(Integer port) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridConnectionProperties();
        }
        this.innerProperties().withPort(port);
        return this;
    }

    public String sendKeyName() {
        return this.innerProperties() == null ? null : this.innerProperties().sendKeyName();
    }

    public HybridConnectionInner withSendKeyName(String sendKeyName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridConnectionProperties();
        }
        this.innerProperties().withSendKeyName(sendKeyName);
        return this;
    }

    public String sendKeyValue() {
        return this.innerProperties() == null ? null : this.innerProperties().sendKeyValue();
    }

    public HybridConnectionInner withSendKeyValue(String sendKeyValue) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridConnectionProperties();
        }
        this.innerProperties().withSendKeyValue(sendKeyValue);
        return this;
    }

    public String serviceBusSuffix() {
        return this.innerProperties() == null ? null : this.innerProperties().serviceBusSuffix();
    }

    public HybridConnectionInner withServiceBusSuffix(String serviceBusSuffix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new HybridConnectionProperties();
        }
        this.innerProperties().withServiceBusSuffix(serviceBusSuffix);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static HybridConnectionInner fromJson(JsonReader jsonReader) throws IOException {
        return (HybridConnectionInner)((Object)jsonReader.readObject(reader -> {
            HybridConnectionInner deserializedHybridConnectionInner = new HybridConnectionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedHybridConnectionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedHybridConnectionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHybridConnectionInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedHybridConnectionInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedHybridConnectionInner.innerProperties = HybridConnectionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHybridConnectionInner;
        }));
    }
}

