/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.FlowAccessControlConfiguration;
import com.azure.resourcemanager.appservice.models.FlowEndpointsConfiguration;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowParameter;
import com.azure.resourcemanager.appservice.models.WorkflowProvisioningState;
import com.azure.resourcemanager.appservice.models.WorkflowSku;
import com.azure.resourcemanager.appservice.models.WorkflowState;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class WorkflowVersionProperties
implements JsonSerializable<WorkflowVersionProperties> {
    private WorkflowProvisioningState provisioningState;
    private OffsetDateTime createdTime;
    private OffsetDateTime changedTime;
    private WorkflowState state;
    private String version;
    private String accessEndpoint;
    private FlowEndpointsConfiguration endpointsConfiguration;
    private FlowAccessControlConfiguration accessControl;
    private WorkflowSku sku;
    private ResourceReference integrationAccount;
    private Object definition;
    private Map<String, WorkflowParameter> parameters;

    public WorkflowProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public OffsetDateTime createdTime() {
        return this.createdTime;
    }

    public OffsetDateTime changedTime() {
        return this.changedTime;
    }

    public WorkflowState state() {
        return this.state;
    }

    public WorkflowVersionProperties withState(WorkflowState state) {
        this.state = state;
        return this;
    }

    public String version() {
        return this.version;
    }

    public String accessEndpoint() {
        return this.accessEndpoint;
    }

    public FlowEndpointsConfiguration endpointsConfiguration() {
        return this.endpointsConfiguration;
    }

    public WorkflowVersionProperties withEndpointsConfiguration(FlowEndpointsConfiguration endpointsConfiguration) {
        this.endpointsConfiguration = endpointsConfiguration;
        return this;
    }

    public FlowAccessControlConfiguration accessControl() {
        return this.accessControl;
    }

    public WorkflowVersionProperties withAccessControl(FlowAccessControlConfiguration accessControl) {
        this.accessControl = accessControl;
        return this;
    }

    public WorkflowSku sku() {
        return this.sku;
    }

    public ResourceReference integrationAccount() {
        return this.integrationAccount;
    }

    public WorkflowVersionProperties withIntegrationAccount(ResourceReference integrationAccount) {
        this.integrationAccount = integrationAccount;
        return this;
    }

    public Object definition() {
        return this.definition;
    }

    public WorkflowVersionProperties withDefinition(Object definition) {
        this.definition = definition;
        return this;
    }

    public Map<String, WorkflowParameter> parameters() {
        return this.parameters;
    }

    public WorkflowVersionProperties withParameters(Map<String, WorkflowParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.endpointsConfiguration() != null) {
            this.endpointsConfiguration().validate();
        }
        if (this.accessControl() != null) {
            this.accessControl().validate();
        }
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.integrationAccount() != null) {
            this.integrationAccount().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeJsonField("endpointsConfiguration", (JsonSerializable)this.endpointsConfiguration);
        jsonWriter.writeJsonField("accessControl", (JsonSerializable)this.accessControl);
        jsonWriter.writeJsonField("integrationAccount", (JsonSerializable)this.integrationAccount);
        jsonWriter.writeUntypedField("definition", this.definition);
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static WorkflowVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return (WorkflowVersionProperties)jsonReader.readObject(reader -> {
            WorkflowVersionProperties deserializedWorkflowVersionProperties = new WorkflowVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("provisioningState".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.provisioningState = WorkflowProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("createdTime".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.createdTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("changedTime".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.changedTime = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.state = WorkflowState.fromString(reader.getString());
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.version = reader.getString();
                    continue;
                }
                if ("accessEndpoint".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.accessEndpoint = reader.getString();
                    continue;
                }
                if ("endpointsConfiguration".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.endpointsConfiguration = FlowEndpointsConfiguration.fromJson(reader);
                    continue;
                }
                if ("accessControl".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.accessControl = FlowAccessControlConfiguration.fromJson(reader);
                    continue;
                }
                if ("sku".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.sku = WorkflowSku.fromJson(reader);
                    continue;
                }
                if ("integrationAccount".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.integrationAccount = ResourceReference.fromJson(reader);
                    continue;
                }
                if ("definition".equals(fieldName)) {
                    deserializedWorkflowVersionProperties.definition = reader.readUntyped();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedWorkflowVersionProperties.parameters = parameters = reader.readMap(reader1 -> WorkflowParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWorkflowVersionProperties;
        });
    }
}

