/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.implementation;

import com.azure.resourcemanager.appservice.fluent.models.SiteLogsConfigInner;
import com.azure.resourcemanager.appservice.implementation.WebAppBaseImpl;
import com.azure.resourcemanager.appservice.models.ApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.AzureBlobStorageApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.AzureBlobStorageHttpLogsConfig;
import com.azure.resourcemanager.appservice.models.EnabledConfig;
import com.azure.resourcemanager.appservice.models.FileSystemApplicationLogsConfig;
import com.azure.resourcemanager.appservice.models.FileSystemHttpLogsConfig;
import com.azure.resourcemanager.appservice.models.HttpLogsConfig;
import com.azure.resourcemanager.appservice.models.LogLevel;
import com.azure.resourcemanager.appservice.models.WebAppBase;
import com.azure.resourcemanager.appservice.models.WebAppDiagnosticLogs;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;

class WebAppDiagnosticLogsImpl<FluentT extends WebAppBase, FluentImplT extends WebAppBaseImpl<FluentT, FluentImplT>>
extends IndexableWrapperImpl<SiteLogsConfigInner>
implements WebAppDiagnosticLogs,
WebAppDiagnosticLogs.Definition<WebAppBase.DefinitionStages.WithCreate<FluentT>>,
WebAppDiagnosticLogs.UpdateDefinition<WebAppBase.Update<FluentT>> {
    private final WebAppBaseImpl<FluentT, FluentImplT> parent;
    private LogLevel applicationLogLevel = null;

    WebAppDiagnosticLogsImpl(SiteLogsConfigInner inner, WebAppBaseImpl<FluentT, FluentImplT> parent) {
        super((Object)inner);
        if (inner.applicationLogs() != null) {
            inner.applicationLogs().withAzureTableStorage(null);
        }
        this.parent = parent;
    }

    @Override
    public LogLevel applicationLoggingFileSystemLogLevel() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().fileSystem() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().fileSystem().level() == null) {
            return LogLevel.OFF;
        }
        return ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().fileSystem().level();
    }

    @Override
    public String applicationLoggingStorageBlobContainer() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage() == null) {
            return null;
        }
        return ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage().sasUrl();
    }

    @Override
    public LogLevel applicationLoggingStorageBlobLogLevel() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage().level() == null) {
            return LogLevel.OFF;
        }
        return ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage().level();
    }

    @Override
    public int applicationLoggingStorageBlobRetentionDays() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage().retentionInDays());
    }

    @Override
    public int webServerLoggingFileSystemQuotaInMB() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().retentionInMb());
    }

    @Override
    public int webServerLoggingFileSystemRetentionDays() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().retentionInDays());
    }

    @Override
    public int webServerLoggingStorageBlobRetentionDays() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage() == null) {
            return 0;
        }
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage().retentionInDays());
    }

    @Override
    public String webServerLoggingStorageBlobContainer() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() == null || ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage() == null) {
            return null;
        }
        return ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage().sasUrl();
    }

    @Override
    public boolean failedRequestsTracing() {
        return ((SiteLogsConfigInner)((Object)this.innerModel())).failedRequestsTracing() != null && ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SiteLogsConfigInner)((Object)this.innerModel())).failedRequestsTracing().enabled());
    }

    @Override
    public boolean detailedErrorMessages() {
        return ((SiteLogsConfigInner)((Object)this.innerModel())).detailedErrorMessages() != null && ResourceManagerUtils.toPrimitiveBoolean((Boolean)((SiteLogsConfigInner)((Object)this.innerModel())).detailedErrorMessages().enabled());
    }

    public FluentImplT attach() {
        this.parent.withDiagnosticLogs(this);
        return (FluentImplT)this.parent();
    }

    public FluentImplT parent() {
        this.parent.withDiagnosticLogs(this);
        return (FluentImplT)this.parent;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogging() {
        ((SiteLogsConfigInner)((Object)this.innerModel())).withApplicationLogs(new ApplicationLogsConfig());
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogging() {
        this.withoutApplicationLogsStoredOnFileSystem();
        this.withoutApplicationLogsStoredOnStorageBlob();
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogging() {
        ((SiteLogsConfigInner)((Object)this.innerModel())).withHttpLogs(new HttpLogsConfig());
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogging() {
        this.withoutWebServerLogsStoredOnFileSystem();
        this.withoutWebServerLogsStoredOnStorageBlob();
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withDetailedErrorMessages(boolean enabled) {
        ((SiteLogsConfigInner)((Object)this.innerModel())).withDetailedErrorMessages(new EnabledConfig().withEnabled(enabled));
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withFailedRequestTracing(boolean enabled) {
        ((SiteLogsConfigInner)((Object)this.innerModel())).withFailedRequestsTracing(new EnabledConfig().withEnabled(enabled));
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs() != null) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().withFileSystem(new FileSystemApplicationLogsConfig().withLevel(this.applicationLogLevel));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withApplicationLogsStoredOnStorageBlob(String containerSasUrl) {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs() != null) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().withAzureBlobStorage(new AzureBlobStorageApplicationLogsConfig().withLevel(this.applicationLogLevel).withSasUrl(containerSasUrl));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().withFileSystem(new FileSystemHttpLogsConfig().withEnabled(true));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerLogsStoredOnStorageBlob(String containerSasUrl) {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().withAzureBlobStorage(new AzureBlobStorageHttpLogsConfig().withEnabled(true).withSasUrl(containerSasUrl));
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem() != null) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().withEnabled(false);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutWebServerLogsStoredOnStorageBlob() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage() != null) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage().withEnabled(false);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withLogLevel(LogLevel logLevel) {
        this.applicationLogLevel = logLevel;
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withWebServerFileSystemQuotaInMB(int quotaInMB) {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().withRetentionInMb(quotaInMB);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withLogRetentionDays(int retentionDays) {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().withRetentionInDays(retentionDays);
        }
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage().withRetentionInDays(retentionDays);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withUnlimitedLogRetentionDays() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().withRetentionInDays(0);
        }
        if (((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().fileSystem().enabled().booleanValue()) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).httpLogs().azureBlobStorage().withRetentionInDays(0);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogsStoredOnFileSystem() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().fileSystem() != null) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().fileSystem().withLevel(LogLevel.OFF);
        }
        return this;
    }

    public WebAppDiagnosticLogsImpl<FluentT, FluentImplT> withoutApplicationLogsStoredOnStorageBlob() {
        if (((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs() != null && ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage() != null) {
            ((SiteLogsConfigInner)((Object)this.innerModel())).applicationLogs().azureBlobStorage().withLevel(LogLevel.OFF);
        }
        return this;
    }
}

