// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * Key Vault container ARM resource for a certificate that is purchased through Azure.
 */
@Fluent
public final class AppServiceCertificatePatchResourceInner extends ProxyOnlyResource {
    /*
     * Core resource properties
     */
    private AppServiceCertificateInner innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of AppServiceCertificatePatchResourceInner class.
     */
    public AppServiceCertificatePatchResourceInner() {
    }

    /**
     * Get the innerProperties property: Core resource properties.
     * 
     * @return the innerProperties value.
     */
    private AppServiceCertificateInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppServiceCertificatePatchResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the keyVaultId property: Key Vault resource Id.
     * 
     * @return the keyVaultId value.
     */
    public String keyVaultId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultId();
    }

    /**
     * Set the keyVaultId property: Key Vault resource Id.
     * 
     * @param keyVaultId the keyVaultId value to set.
     * @return the AppServiceCertificatePatchResourceInner object itself.
     */
    public AppServiceCertificatePatchResourceInner withKeyVaultId(String keyVaultId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceCertificateInner();
        }
        this.innerProperties().withKeyVaultId(keyVaultId);
        return this;
    }

    /**
     * Get the keyVaultSecretName property: Key Vault secret name.
     * 
     * @return the keyVaultSecretName value.
     */
    public String keyVaultSecretName() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultSecretName();
    }

    /**
     * Set the keyVaultSecretName property: Key Vault secret name.
     * 
     * @param keyVaultSecretName the keyVaultSecretName value to set.
     * @return the AppServiceCertificatePatchResourceInner object itself.
     */
    public AppServiceCertificatePatchResourceInner withKeyVaultSecretName(String keyVaultSecretName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceCertificateInner();
        }
        this.innerProperties().withKeyVaultSecretName(keyVaultSecretName);
        return this;
    }

    /**
     * Get the provisioningState property: Status of the Key Vault secret.
     * 
     * @return the provisioningState value.
     */
    public KeyVaultSecretStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppServiceCertificatePatchResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppServiceCertificatePatchResourceInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AppServiceCertificatePatchResourceInner.
     */
    public static AppServiceCertificatePatchResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppServiceCertificatePatchResourceInner deserializedAppServiceCertificatePatchResourceInner
                = new AppServiceCertificatePatchResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAppServiceCertificatePatchResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAppServiceCertificatePatchResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAppServiceCertificatePatchResourceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedAppServiceCertificatePatchResourceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedAppServiceCertificatePatchResourceInner.innerProperties
                        = AppServiceCertificateInner.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppServiceCertificatePatchResourceInner;
        });
    }
}
