// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.PrivateAccessVirtualNetwork;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

/**
 * Description of the parameters of Private Access for a Web Site.
 */
@Fluent
public final class PrivateAccessInner extends ProxyOnlyResource {
    /*
     * PrivateAccess resource specific properties
     */
    private PrivateAccessProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of PrivateAccessInner class.
     */
    public PrivateAccessInner() {
    }

    /**
     * Get the innerProperties property: PrivateAccess resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private PrivateAccessProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PrivateAccessInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the enabled property: Whether private access is enabled or not.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Whether private access is enabled or not.
     * 
     * @param enabled the enabled value to set.
     * @return the PrivateAccessInner object itself.
     */
    public PrivateAccessInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateAccessProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Get the virtualNetworks property: The Virtual Networks (and subnets) allowed to access the site privately.
     * 
     * @return the virtualNetworks value.
     */
    public List<PrivateAccessVirtualNetwork> virtualNetworks() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworks();
    }

    /**
     * Set the virtualNetworks property: The Virtual Networks (and subnets) allowed to access the site privately.
     * 
     * @param virtualNetworks the virtualNetworks value to set.
     * @return the PrivateAccessInner object itself.
     */
    public PrivateAccessInner withVirtualNetworks(List<PrivateAccessVirtualNetwork> virtualNetworks) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PrivateAccessProperties();
        }
        this.innerProperties().withVirtualNetworks(virtualNetworks);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PrivateAccessInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PrivateAccessInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PrivateAccessInner.
     */
    public static PrivateAccessInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PrivateAccessInner deserializedPrivateAccessInner = new PrivateAccessInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPrivateAccessInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPrivateAccessInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPrivateAccessInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedPrivateAccessInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedPrivateAccessInner.innerProperties = PrivateAccessProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPrivateAccessInner;
        });
    }
}
