// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * Static Site User ARM resource.
 */
@Fluent
public final class StaticSiteUserArmResourceInner extends ProxyOnlyResource {
    /*
     * StaticSiteUserARMResource resource specific properties
     */
    private StaticSiteUserArmResourceProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of StaticSiteUserArmResourceInner class.
     */
    public StaticSiteUserArmResourceInner() {
    }

    /**
     * Get the innerProperties property: StaticSiteUserARMResource resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private StaticSiteUserArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticSiteUserArmResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the provider property: The identity provider for the static site user.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.innerProperties() == null ? null : this.innerProperties().provider();
    }

    /**
     * Get the userId property: The user id for the static site user.
     * 
     * @return the userId value.
     */
    public String userId() {
        return this.innerProperties() == null ? null : this.innerProperties().userId();
    }

    /**
     * Get the displayName property: The display name for the static site user.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.innerProperties() == null ? null : this.innerProperties().displayName();
    }

    /**
     * Get the roles property: The roles for the static site user, in free-form string format.
     * 
     * @return the roles value.
     */
    public String roles() {
        return this.innerProperties() == null ? null : this.innerProperties().roles();
    }

    /**
     * Set the roles property: The roles for the static site user, in free-form string format.
     * 
     * @param roles the roles value to set.
     * @return the StaticSiteUserArmResourceInner object itself.
     */
    public StaticSiteUserArmResourceInner withRoles(String roles) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteUserArmResourceProperties();
        }
        this.innerProperties().withRoles(roles);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteUserArmResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteUserArmResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticSiteUserArmResourceInner.
     */
    public static StaticSiteUserArmResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteUserArmResourceInner deserializedStaticSiteUserArmResourceInner
                = new StaticSiteUserArmResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStaticSiteUserArmResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStaticSiteUserArmResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticSiteUserArmResourceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStaticSiteUserArmResourceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticSiteUserArmResourceInner.innerProperties
                        = StaticSiteUserArmResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteUserArmResourceInner;
        });
    }
}
