// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The workflow run action correlation properties.
 */
@Fluent
public final class RunActionCorrelation extends RunCorrelation {
    /*
     * The action tracking identifier.
     */
    private String actionTrackingId;

    /**
     * Creates an instance of RunActionCorrelation class.
     */
    public RunActionCorrelation() {
    }

    /**
     * Get the actionTrackingId property: The action tracking identifier.
     * 
     * @return the actionTrackingId value.
     */
    public String actionTrackingId() {
        return this.actionTrackingId;
    }

    /**
     * Set the actionTrackingId property: The action tracking identifier.
     * 
     * @param actionTrackingId the actionTrackingId value to set.
     * @return the RunActionCorrelation object itself.
     */
    public RunActionCorrelation withActionTrackingId(String actionTrackingId) {
        this.actionTrackingId = actionTrackingId;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RunActionCorrelation withClientTrackingId(String clientTrackingId) {
        super.withClientTrackingId(clientTrackingId);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public RunActionCorrelation withClientKeywords(List<String> clientKeywords) {
        super.withClientKeywords(clientKeywords);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientTrackingId", clientTrackingId());
        jsonWriter.writeArrayField("clientKeywords", clientKeywords(),
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("actionTrackingId", this.actionTrackingId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunActionCorrelation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunActionCorrelation if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RunActionCorrelation.
     */
    public static RunActionCorrelation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunActionCorrelation deserializedRunActionCorrelation = new RunActionCorrelation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientTrackingId".equals(fieldName)) {
                    deserializedRunActionCorrelation.withClientTrackingId(reader.getString());
                } else if ("clientKeywords".equals(fieldName)) {
                    List<String> clientKeywords = reader.readArray(reader1 -> reader1.getString());
                    deserializedRunActionCorrelation.withClientKeywords(clientKeywords);
                } else if ("actionTrackingId".equals(fieldName)) {
                    deserializedRunActionCorrelation.actionTrackingId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunActionCorrelation;
        });
    }
}
