// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Site config properties dictionary.
 */
@Immutable
public final class SiteConfigPropertiesDictionary implements JsonSerializable<SiteConfigPropertiesDictionary> {
    /*
     * <code>true</code> if use32BitWorkerProcess should be set to true for the stack; otherwise, <code>false</code>.
     */
    private Boolean use32BitWorkerProcess;

    /*
     * LinuxFxVersion configuration setting.
     */
    private String linuxFxVersion;

    /*
     * JavaVersion configuration setting.
     */
    private String javaVersion;

    /*
     * PowerShellVersion configuration setting.
     */
    private String powerShellVersion;

    /**
     * Creates an instance of SiteConfigPropertiesDictionary class.
     */
    public SiteConfigPropertiesDictionary() {
    }

    /**
     * Get the use32BitWorkerProcess property: &lt;code&gt;true&lt;/code&gt; if use32BitWorkerProcess should be set to
     * true for the stack; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the use32BitWorkerProcess value.
     */
    public Boolean use32BitWorkerProcess() {
        return this.use32BitWorkerProcess;
    }

    /**
     * Get the linuxFxVersion property: LinuxFxVersion configuration setting.
     * 
     * @return the linuxFxVersion value.
     */
    public String linuxFxVersion() {
        return this.linuxFxVersion;
    }

    /**
     * Get the javaVersion property: JavaVersion configuration setting.
     * 
     * @return the javaVersion value.
     */
    public String javaVersion() {
        return this.javaVersion;
    }

    /**
     * Get the powerShellVersion property: PowerShellVersion configuration setting.
     * 
     * @return the powerShellVersion value.
     */
    public String powerShellVersion() {
        return this.powerShellVersion;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteConfigPropertiesDictionary from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteConfigPropertiesDictionary if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SiteConfigPropertiesDictionary.
     */
    public static SiteConfigPropertiesDictionary fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteConfigPropertiesDictionary deserializedSiteConfigPropertiesDictionary
                = new SiteConfigPropertiesDictionary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("use32BitWorkerProcess".equals(fieldName)) {
                    deserializedSiteConfigPropertiesDictionary.use32BitWorkerProcess
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("linuxFxVersion".equals(fieldName)) {
                    deserializedSiteConfigPropertiesDictionary.linuxFxVersion = reader.getString();
                } else if ("javaVersion".equals(fieldName)) {
                    deserializedSiteConfigPropertiesDictionary.javaVersion = reader.getString();
                } else if ("powerShellVersion".equals(fieldName)) {
                    deserializedSiteConfigPropertiesDictionary.powerShellVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteConfigPropertiesDictionary;
        });
    }
}
