// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteZipDeployment;
import java.io.IOException;

/**
 * Static site zip deployment ARM resource.
 */
@Fluent
public final class StaticSiteZipDeploymentArmResource extends ProxyOnlyResource {
    /*
     * Core resource properties
     */
    private StaticSiteZipDeployment innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of StaticSiteZipDeploymentArmResource class.
     */
    public StaticSiteZipDeploymentArmResource() {
    }

    /**
     * Get the innerProperties property: Core resource properties.
     * 
     * @return the innerProperties value.
     */
    private StaticSiteZipDeployment innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticSiteZipDeploymentArmResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the appZipUrl property: URL for the zipped app content.
     * 
     * @return the appZipUrl value.
     */
    public String appZipUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().appZipUrl();
    }

    /**
     * Set the appZipUrl property: URL for the zipped app content.
     * 
     * @param appZipUrl the appZipUrl value to set.
     * @return the StaticSiteZipDeploymentArmResource object itself.
     */
    public StaticSiteZipDeploymentArmResource withAppZipUrl(String appZipUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteZipDeployment();
        }
        this.innerProperties().withAppZipUrl(appZipUrl);
        return this;
    }

    /**
     * Get the apiZipUrl property: URL for the zipped api content.
     * 
     * @return the apiZipUrl value.
     */
    public String apiZipUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().apiZipUrl();
    }

    /**
     * Set the apiZipUrl property: URL for the zipped api content.
     * 
     * @param apiZipUrl the apiZipUrl value to set.
     * @return the StaticSiteZipDeploymentArmResource object itself.
     */
    public StaticSiteZipDeploymentArmResource withApiZipUrl(String apiZipUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteZipDeployment();
        }
        this.innerProperties().withApiZipUrl(apiZipUrl);
        return this;
    }

    /**
     * Get the deploymentTitle property: A title to label the deployment.
     * 
     * @return the deploymentTitle value.
     */
    public String deploymentTitle() {
        return this.innerProperties() == null ? null : this.innerProperties().deploymentTitle();
    }

    /**
     * Set the deploymentTitle property: A title to label the deployment.
     * 
     * @param deploymentTitle the deploymentTitle value to set.
     * @return the StaticSiteZipDeploymentArmResource object itself.
     */
    public StaticSiteZipDeploymentArmResource withDeploymentTitle(String deploymentTitle) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteZipDeployment();
        }
        this.innerProperties().withDeploymentTitle(deploymentTitle);
        return this;
    }

    /**
     * Get the provider property: The provider submitting this deployment.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.innerProperties() == null ? null : this.innerProperties().provider();
    }

    /**
     * Set the provider property: The provider submitting this deployment.
     * 
     * @param provider the provider value to set.
     * @return the StaticSiteZipDeploymentArmResource object itself.
     */
    public StaticSiteZipDeploymentArmResource withProvider(String provider) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteZipDeployment();
        }
        this.innerProperties().withProvider(provider);
        return this;
    }

    /**
     * Get the functionLanguage property: The language of the api content, if it exists.
     * 
     * @return the functionLanguage value.
     */
    public String functionLanguage() {
        return this.innerProperties() == null ? null : this.innerProperties().functionLanguage();
    }

    /**
     * Set the functionLanguage property: The language of the api content, if it exists.
     * 
     * @param functionLanguage the functionLanguage value to set.
     * @return the StaticSiteZipDeploymentArmResource object itself.
     */
    public StaticSiteZipDeploymentArmResource withFunctionLanguage(String functionLanguage) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteZipDeployment();
        }
        this.innerProperties().withFunctionLanguage(functionLanguage);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteZipDeploymentArmResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteZipDeploymentArmResource if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticSiteZipDeploymentArmResource.
     */
    public static StaticSiteZipDeploymentArmResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteZipDeploymentArmResource deserializedStaticSiteZipDeploymentArmResource
                = new StaticSiteZipDeploymentArmResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStaticSiteZipDeploymentArmResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStaticSiteZipDeploymentArmResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticSiteZipDeploymentArmResource.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStaticSiteZipDeploymentArmResource.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticSiteZipDeploymentArmResource.innerProperties
                        = StaticSiteZipDeployment.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteZipDeploymentArmResource;
        });
    }
}
