// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Job type.
 */
public enum WebJobType {
    /**
     * Enum value Continuous.
     */
    CONTINUOUS("Continuous"),

    /**
     * Enum value Triggered.
     */
    TRIGGERED("Triggered");

    /**
     * The actual serialized value for a WebJobType instance.
     */
    private final String value;

    WebJobType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a WebJobType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed WebJobType object, or null if unable to parse.
     */
    public static WebJobType fromString(String value) {
        if (value == null) {
            return null;
        }
        WebJobType[] items = WebJobType.values();
        for (WebJobType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
