/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.BackupRequestProperties;
import com.azure.resourcemanager.appservice.models.BackupSchedule;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.util.List;

public final class BackupRequestInner
extends ProxyOnlyResource {
    private BackupRequestProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private BackupRequestProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public BackupRequestInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public String backupName() {
        return this.innerProperties() == null ? null : this.innerProperties().backupName();
    }

    public BackupRequestInner withBackupName(String backupName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupRequestProperties();
        }
        this.innerProperties().withBackupName(backupName);
        return this;
    }

    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    public BackupRequestInner withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupRequestProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    public String storageAccountUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountUrl();
    }

    public BackupRequestInner withStorageAccountUrl(String storageAccountUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupRequestProperties();
        }
        this.innerProperties().withStorageAccountUrl(storageAccountUrl);
        return this;
    }

    public BackupSchedule backupSchedule() {
        return this.innerProperties() == null ? null : this.innerProperties().backupSchedule();
    }

    public BackupRequestInner withBackupSchedule(BackupSchedule backupSchedule) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupRequestProperties();
        }
        this.innerProperties().withBackupSchedule(backupSchedule);
        return this;
    }

    public List<DatabaseBackupSetting> databases() {
        return this.innerProperties() == null ? null : this.innerProperties().databases();
    }

    public BackupRequestInner withDatabases(List<DatabaseBackupSetting> databases) {
        if (this.innerProperties() == null) {
            this.innerProperties = new BackupRequestProperties();
        }
        this.innerProperties().withDatabases(databases);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BackupRequestInner fromJson(JsonReader jsonReader) throws IOException {
        return (BackupRequestInner)((Object)jsonReader.readObject(reader -> {
            BackupRequestInner deserializedBackupRequestInner = new BackupRequestInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackupRequestInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupRequestInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackupRequestInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedBackupRequestInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackupRequestInner.innerProperties = BackupRequestProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupRequestInner;
        }));
    }
}

