// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import java.io.IOException;
import java.util.Map;

/**
 * Key Vault container ARM resource for a certificate that is purchased through Azure.
 */
@Fluent
public final class AppServiceCertificateResourceInner extends Resource {
    /*
     * Core resource properties
     */
    private AppServiceCertificateInner innerProperties;

    /*
     * Kind of resource.
     */
    private String kind;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of AppServiceCertificateResourceInner class.
     */
    public AppServiceCertificateResourceInner() {
    }

    /**
     * Get the innerProperties property: Core resource properties.
     * 
     * @return the innerProperties value.
     */
    private AppServiceCertificateInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the kind property: Kind of resource.
     * 
     * @return the kind value.
     */
    public String kind() {
        return this.kind;
    }

    /**
     * Set the kind property: Kind of resource.
     * 
     * @param kind the kind value to set.
     * @return the AppServiceCertificateResourceInner object itself.
     */
    public AppServiceCertificateResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppServiceCertificateResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppServiceCertificateResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the keyVaultId property: Key Vault resource Id.
     * 
     * @return the keyVaultId value.
     */
    public String keyVaultId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultId();
    }

    /**
     * Set the keyVaultId property: Key Vault resource Id.
     * 
     * @param keyVaultId the keyVaultId value to set.
     * @return the AppServiceCertificateResourceInner object itself.
     */
    public AppServiceCertificateResourceInner withKeyVaultId(String keyVaultId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceCertificateInner();
        }
        this.innerProperties().withKeyVaultId(keyVaultId);
        return this;
    }

    /**
     * Get the keyVaultSecretName property: Key Vault secret name.
     * 
     * @return the keyVaultSecretName value.
     */
    public String keyVaultSecretName() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultSecretName();
    }

    /**
     * Set the keyVaultSecretName property: Key Vault secret name.
     * 
     * @param keyVaultSecretName the keyVaultSecretName value to set.
     * @return the AppServiceCertificateResourceInner object itself.
     */
    public AppServiceCertificateResourceInner withKeyVaultSecretName(String keyVaultSecretName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceCertificateInner();
        }
        this.innerProperties().withKeyVaultSecretName(keyVaultSecretName);
        return this;
    }

    /**
     * Get the provisioningState property: Status of the Key Vault secret.
     * 
     * @return the provisioningState value.
     */
    public KeyVaultSecretStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppServiceCertificateResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppServiceCertificateResourceInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AppServiceCertificateResourceInner.
     */
    public static AppServiceCertificateResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppServiceCertificateResourceInner deserializedAppServiceCertificateResourceInner
                = new AppServiceCertificateResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAppServiceCertificateResourceInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.innerProperties
                        = AppServiceCertificateInner.fromJson(reader);
                } else if ("kind".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.kind = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppServiceCertificateResourceInner;
        });
    }
}
