// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.OperationStatus;
import java.io.IOException;

/**
 * MigrateMySqlStatus resource specific properties.
 */
@Immutable
public final class MigrateMySqlStatusProperties implements JsonSerializable<MigrateMySqlStatusProperties> {
    /*
     * Status of the migration task.
     */
    private OperationStatus migrationOperationStatus;

    /*
     * Operation ID for the migration task.
     */
    private String operationId;

    /*
     * True if the web app has in app MySql enabled
     */
    private Boolean localMySqlEnabled;

    /**
     * Creates an instance of MigrateMySqlStatusProperties class.
     */
    public MigrateMySqlStatusProperties() {
    }

    /**
     * Get the migrationOperationStatus property: Status of the migration task.
     * 
     * @return the migrationOperationStatus value.
     */
    public OperationStatus migrationOperationStatus() {
        return this.migrationOperationStatus;
    }

    /**
     * Get the operationId property: Operation ID for the migration task.
     * 
     * @return the operationId value.
     */
    public String operationId() {
        return this.operationId;
    }

    /**
     * Get the localMySqlEnabled property: True if the web app has in app MySql enabled.
     * 
     * @return the localMySqlEnabled value.
     */
    public Boolean localMySqlEnabled() {
        return this.localMySqlEnabled;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateMySqlStatusProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateMySqlStatusProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the MigrateMySqlStatusProperties.
     */
    public static MigrateMySqlStatusProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateMySqlStatusProperties deserializedMigrateMySqlStatusProperties = new MigrateMySqlStatusProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("migrationOperationStatus".equals(fieldName)) {
                    deserializedMigrateMySqlStatusProperties.migrationOperationStatus
                        = OperationStatus.fromString(reader.getString());
                } else if ("operationId".equals(fieldName)) {
                    deserializedMigrateMySqlStatusProperties.operationId = reader.getString();
                } else if ("localMySqlEnabled".equals(fieldName)) {
                    deserializedMigrateMySqlStatusProperties.localMySqlEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateMySqlStatusProperties;
        });
    }
}
