// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * ProcessModuleInfo resource specific properties.
 */
@Fluent
public final class ProcessModuleInfoProperties implements JsonSerializable<ProcessModuleInfoProperties> {
    /*
     * Base address. Used as module identifier in ARM resource URI.
     */
    private String baseAddress;

    /*
     * File name.
     */
    private String fileName;

    /*
     * HRef URI.
     */
    private String href;

    /*
     * File path.
     */
    private String filePath;

    /*
     * Module memory size.
     */
    private Integer moduleMemorySize;

    /*
     * File version.
     */
    private String fileVersion;

    /*
     * File description.
     */
    private String fileDescription;

    /*
     * Product name.
     */
    private String product;

    /*
     * Product version.
     */
    private String productVersion;

    /*
     * Is debug?
     */
    private Boolean isDebug;

    /*
     * Module language (locale).
     */
    private String language;

    /**
     * Creates an instance of ProcessModuleInfoProperties class.
     */
    public ProcessModuleInfoProperties() {
    }

    /**
     * Get the baseAddress property: Base address. Used as module identifier in ARM resource URI.
     * 
     * @return the baseAddress value.
     */
    public String baseAddress() {
        return this.baseAddress;
    }

    /**
     * Set the baseAddress property: Base address. Used as module identifier in ARM resource URI.
     * 
     * @param baseAddress the baseAddress value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
        return this;
    }

    /**
     * Get the fileName property: File name.
     * 
     * @return the fileName value.
     */
    public String fileName() {
        return this.fileName;
    }

    /**
     * Set the fileName property: File name.
     * 
     * @param fileName the fileName value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withFileName(String fileName) {
        this.fileName = fileName;
        return this;
    }

    /**
     * Get the href property: HRef URI.
     * 
     * @return the href value.
     */
    public String href() {
        return this.href;
    }

    /**
     * Set the href property: HRef URI.
     * 
     * @param href the href value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withHref(String href) {
        this.href = href;
        return this;
    }

    /**
     * Get the filePath property: File path.
     * 
     * @return the filePath value.
     */
    public String filePath() {
        return this.filePath;
    }

    /**
     * Set the filePath property: File path.
     * 
     * @param filePath the filePath value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withFilePath(String filePath) {
        this.filePath = filePath;
        return this;
    }

    /**
     * Get the moduleMemorySize property: Module memory size.
     * 
     * @return the moduleMemorySize value.
     */
    public Integer moduleMemorySize() {
        return this.moduleMemorySize;
    }

    /**
     * Set the moduleMemorySize property: Module memory size.
     * 
     * @param moduleMemorySize the moduleMemorySize value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withModuleMemorySize(Integer moduleMemorySize) {
        this.moduleMemorySize = moduleMemorySize;
        return this;
    }

    /**
     * Get the fileVersion property: File version.
     * 
     * @return the fileVersion value.
     */
    public String fileVersion() {
        return this.fileVersion;
    }

    /**
     * Set the fileVersion property: File version.
     * 
     * @param fileVersion the fileVersion value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withFileVersion(String fileVersion) {
        this.fileVersion = fileVersion;
        return this;
    }

    /**
     * Get the fileDescription property: File description.
     * 
     * @return the fileDescription value.
     */
    public String fileDescription() {
        return this.fileDescription;
    }

    /**
     * Set the fileDescription property: File description.
     * 
     * @param fileDescription the fileDescription value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withFileDescription(String fileDescription) {
        this.fileDescription = fileDescription;
        return this;
    }

    /**
     * Get the product property: Product name.
     * 
     * @return the product value.
     */
    public String product() {
        return this.product;
    }

    /**
     * Set the product property: Product name.
     * 
     * @param product the product value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withProduct(String product) {
        this.product = product;
        return this;
    }

    /**
     * Get the productVersion property: Product version.
     * 
     * @return the productVersion value.
     */
    public String productVersion() {
        return this.productVersion;
    }

    /**
     * Set the productVersion property: Product version.
     * 
     * @param productVersion the productVersion value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withProductVersion(String productVersion) {
        this.productVersion = productVersion;
        return this;
    }

    /**
     * Get the isDebug property: Is debug?.
     * 
     * @return the isDebug value.
     */
    public Boolean isDebug() {
        return this.isDebug;
    }

    /**
     * Set the isDebug property: Is debug?.
     * 
     * @param isDebug the isDebug value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withIsDebug(Boolean isDebug) {
        this.isDebug = isDebug;
        return this;
    }

    /**
     * Get the language property: Module language (locale).
     * 
     * @return the language value.
     */
    public String language() {
        return this.language;
    }

    /**
     * Set the language property: Module language (locale).
     * 
     * @param language the language value to set.
     * @return the ProcessModuleInfoProperties object itself.
     */
    public ProcessModuleInfoProperties withLanguage(String language) {
        this.language = language;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("base_address", this.baseAddress);
        jsonWriter.writeStringField("file_name", this.fileName);
        jsonWriter.writeStringField("href", this.href);
        jsonWriter.writeStringField("file_path", this.filePath);
        jsonWriter.writeNumberField("module_memory_size", this.moduleMemorySize);
        jsonWriter.writeStringField("file_version", this.fileVersion);
        jsonWriter.writeStringField("file_description", this.fileDescription);
        jsonWriter.writeStringField("product", this.product);
        jsonWriter.writeStringField("product_version", this.productVersion);
        jsonWriter.writeBooleanField("is_debug", this.isDebug);
        jsonWriter.writeStringField("language", this.language);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProcessModuleInfoProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProcessModuleInfoProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProcessModuleInfoProperties.
     */
    public static ProcessModuleInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProcessModuleInfoProperties deserializedProcessModuleInfoProperties = new ProcessModuleInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("base_address".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.baseAddress = reader.getString();
                } else if ("file_name".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.fileName = reader.getString();
                } else if ("href".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.href = reader.getString();
                } else if ("file_path".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.filePath = reader.getString();
                } else if ("module_memory_size".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.moduleMemorySize = reader.getNullable(JsonReader::getInt);
                } else if ("file_version".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.fileVersion = reader.getString();
                } else if ("file_description".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.fileDescription = reader.getString();
                } else if ("product".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.product = reader.getString();
                } else if ("product_version".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.productVersion = reader.getString();
                } else if ("is_debug".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.isDebug = reader.getNullable(JsonReader::getBoolean);
                } else if ("language".equals(fieldName)) {
                    deserializedProcessModuleInfoProperties.language = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProcessModuleInfoProperties;
        });
    }
}
