// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.PublicCertificateLocation;
import java.io.IOException;

/**
 * Public certificate object.
 */
@Fluent
public final class PublicCertificateInner extends ProxyOnlyResource {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    /*
     * PublicCertificate resource specific properties
     */
    private PublicCertificateProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of PublicCertificateInner class.
     */
    public PublicCertificateInner() {
    }

    /**
     * Get the innerProperties property: PublicCertificate resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private PublicCertificateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public PublicCertificateInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the blob property: Public Certificate byte array.
     * 
     * @return the blob value.
     */
    public byte[] blob() {
        return this.innerProperties() == null ? EMPTY_BYTE_ARRAY : this.innerProperties().blob();
    }

    /**
     * Set the blob property: Public Certificate byte array.
     * 
     * @param blob the blob value to set.
     * @return the PublicCertificateInner object itself.
     */
    public PublicCertificateInner withBlob(byte[] blob) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicCertificateProperties();
        }
        this.innerProperties().withBlob(blob);
        return this;
    }

    /**
     * Get the publicCertificateLocation property: Public Certificate Location.
     * 
     * @return the publicCertificateLocation value.
     */
    public PublicCertificateLocation publicCertificateLocation() {
        return this.innerProperties() == null ? null : this.innerProperties().publicCertificateLocation();
    }

    /**
     * Set the publicCertificateLocation property: Public Certificate Location.
     * 
     * @param publicCertificateLocation the publicCertificateLocation value to set.
     * @return the PublicCertificateInner object itself.
     */
    public PublicCertificateInner withPublicCertificateLocation(PublicCertificateLocation publicCertificateLocation) {
        if (this.innerProperties() == null) {
            this.innerProperties = new PublicCertificateProperties();
        }
        this.innerProperties().withPublicCertificateLocation(publicCertificateLocation);
        return this;
    }

    /**
     * Get the thumbprint property: Certificate Thumbprint.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.innerProperties() == null ? null : this.innerProperties().thumbprint();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PublicCertificateInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PublicCertificateInner if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the PublicCertificateInner.
     */
    public static PublicCertificateInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PublicCertificateInner deserializedPublicCertificateInner = new PublicCertificateInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedPublicCertificateInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedPublicCertificateInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedPublicCertificateInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedPublicCertificateInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedPublicCertificateInner.innerProperties = PublicCertificateProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPublicCertificateInner;
        });
    }
}
