// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.Channels;
import com.azure.resourcemanager.appservice.models.NotificationLevel;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.UUID;

/**
 * RecommendationRule resource specific properties.
 */
@Fluent
public final class RecommendationRuleProperties implements JsonSerializable<RecommendationRuleProperties> {
    /*
     * Unique name of the rule.
     */
    private String recommendationName;

    /*
     * UI friendly name of the rule.
     */
    private String displayName;

    /*
     * Localized name of the rule (Good for UI).
     */
    private String message;

    /*
     * Recommendation ID of an associated recommendation object tied to the rule, if exists.
     * If such an object doesn't exist, it is set to null.
     */
    private UUID recommendationId;

    /*
     * Localized detailed description of the rule.
     */
    private String description;

    /*
     * Name of action that is recommended by this rule in string.
     */
    private String actionName;

    /*
     * Level of impact indicating how critical this rule is.
     */
    private NotificationLevel level;

    /*
     * List of available channels that this rule applies.
     */
    private Channels channels;

    /*
     * The list of category tags that this recommendation rule belongs to.
     */
    private List<String> categoryTags;

    /*
     * True if this is associated with a dynamically added rule
     */
    private Boolean isDynamic;

    /*
     * Extension name of the portal if exists. Applicable to dynamic rule only.
     */
    private String extensionName;

    /*
     * Deep link to a blade on the portal. Applicable to dynamic rule only.
     */
    private String bladeName;

    /*
     * Forward link to an external document associated with the rule. Applicable to dynamic rule only.
     */
    private String forwardLink;

    /**
     * Creates an instance of RecommendationRuleProperties class.
     */
    public RecommendationRuleProperties() {
    }

    /**
     * Get the recommendationName property: Unique name of the rule.
     * 
     * @return the recommendationName value.
     */
    public String recommendationName() {
        return this.recommendationName;
    }

    /**
     * Set the recommendationName property: Unique name of the rule.
     * 
     * @param recommendationName the recommendationName value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withRecommendationName(String recommendationName) {
        this.recommendationName = recommendationName;
        return this;
    }

    /**
     * Get the displayName property: UI friendly name of the rule.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: UI friendly name of the rule.
     * 
     * @param displayName the displayName value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the message property: Localized name of the rule (Good for UI).
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: Localized name of the rule (Good for UI).
     * 
     * @param message the message value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the recommendationId property: Recommendation ID of an associated recommendation object tied to the rule, if
     * exists.
     * If such an object doesn't exist, it is set to null.
     * 
     * @return the recommendationId value.
     */
    public UUID recommendationId() {
        return this.recommendationId;
    }

    /**
     * Set the recommendationId property: Recommendation ID of an associated recommendation object tied to the rule, if
     * exists.
     * If such an object doesn't exist, it is set to null.
     * 
     * @param recommendationId the recommendationId value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withRecommendationId(UUID recommendationId) {
        this.recommendationId = recommendationId;
        return this;
    }

    /**
     * Get the description property: Localized detailed description of the rule.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Localized detailed description of the rule.
     * 
     * @param description the description value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the actionName property: Name of action that is recommended by this rule in string.
     * 
     * @return the actionName value.
     */
    public String actionName() {
        return this.actionName;
    }

    /**
     * Set the actionName property: Name of action that is recommended by this rule in string.
     * 
     * @param actionName the actionName value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withActionName(String actionName) {
        this.actionName = actionName;
        return this;
    }

    /**
     * Get the level property: Level of impact indicating how critical this rule is.
     * 
     * @return the level value.
     */
    public NotificationLevel level() {
        return this.level;
    }

    /**
     * Set the level property: Level of impact indicating how critical this rule is.
     * 
     * @param level the level value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withLevel(NotificationLevel level) {
        this.level = level;
        return this;
    }

    /**
     * Get the channels property: List of available channels that this rule applies.
     * 
     * @return the channels value.
     */
    public Channels channels() {
        return this.channels;
    }

    /**
     * Set the channels property: List of available channels that this rule applies.
     * 
     * @param channels the channels value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withChannels(Channels channels) {
        this.channels = channels;
        return this;
    }

    /**
     * Get the categoryTags property: The list of category tags that this recommendation rule belongs to.
     * 
     * @return the categoryTags value.
     */
    public List<String> categoryTags() {
        return this.categoryTags;
    }

    /**
     * Get the isDynamic property: True if this is associated with a dynamically added rule.
     * 
     * @return the isDynamic value.
     */
    public Boolean isDynamic() {
        return this.isDynamic;
    }

    /**
     * Set the isDynamic property: True if this is associated with a dynamically added rule.
     * 
     * @param isDynamic the isDynamic value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withIsDynamic(Boolean isDynamic) {
        this.isDynamic = isDynamic;
        return this;
    }

    /**
     * Get the extensionName property: Extension name of the portal if exists. Applicable to dynamic rule only.
     * 
     * @return the extensionName value.
     */
    public String extensionName() {
        return this.extensionName;
    }

    /**
     * Set the extensionName property: Extension name of the portal if exists. Applicable to dynamic rule only.
     * 
     * @param extensionName the extensionName value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withExtensionName(String extensionName) {
        this.extensionName = extensionName;
        return this;
    }

    /**
     * Get the bladeName property: Deep link to a blade on the portal. Applicable to dynamic rule only.
     * 
     * @return the bladeName value.
     */
    public String bladeName() {
        return this.bladeName;
    }

    /**
     * Set the bladeName property: Deep link to a blade on the portal. Applicable to dynamic rule only.
     * 
     * @param bladeName the bladeName value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withBladeName(String bladeName) {
        this.bladeName = bladeName;
        return this;
    }

    /**
     * Get the forwardLink property: Forward link to an external document associated with the rule. Applicable to
     * dynamic rule only.
     * 
     * @return the forwardLink value.
     */
    public String forwardLink() {
        return this.forwardLink;
    }

    /**
     * Set the forwardLink property: Forward link to an external document associated with the rule. Applicable to
     * dynamic rule only.
     * 
     * @param forwardLink the forwardLink value to set.
     * @return the RecommendationRuleProperties object itself.
     */
    public RecommendationRuleProperties withForwardLink(String forwardLink) {
        this.forwardLink = forwardLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("recommendationName", this.recommendationName);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("recommendationId", Objects.toString(this.recommendationId, null));
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("actionName", this.actionName);
        jsonWriter.writeStringField("level", this.level == null ? null : this.level.toString());
        jsonWriter.writeStringField("channels", this.channels == null ? null : this.channels.toString());
        jsonWriter.writeBooleanField("isDynamic", this.isDynamic);
        jsonWriter.writeStringField("extensionName", this.extensionName);
        jsonWriter.writeStringField("bladeName", this.bladeName);
        jsonWriter.writeStringField("forwardLink", this.forwardLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RecommendationRuleProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RecommendationRuleProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RecommendationRuleProperties.
     */
    public static RecommendationRuleProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RecommendationRuleProperties deserializedRecommendationRuleProperties = new RecommendationRuleProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("recommendationName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.recommendationName = reader.getString();
                } else if ("displayName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.displayName = reader.getString();
                } else if ("message".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.message = reader.getString();
                } else if ("recommendationId".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.recommendationId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("description".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.description = reader.getString();
                } else if ("actionName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.actionName = reader.getString();
                } else if ("level".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.level = NotificationLevel.fromString(reader.getString());
                } else if ("channels".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.channels = Channels.fromString(reader.getString());
                } else if ("categoryTags".equals(fieldName)) {
                    List<String> categoryTags = reader.readArray(reader1 -> reader1.getString());
                    deserializedRecommendationRuleProperties.categoryTags = categoryTags;
                } else if ("isDynamic".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.isDynamic = reader.getNullable(JsonReader::getBoolean);
                } else if ("extensionName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.extensionName = reader.getString();
                } else if ("bladeName".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.bladeName = reader.getString();
                } else if ("forwardLink".equals(fieldName)) {
                    deserializedRecommendationRuleProperties.forwardLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRecommendationRuleProperties;
        });
    }
}
