// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * SiteConfigurationSnapshotInfo resource specific properties.
 */
@Immutable
public final class SiteConfigurationSnapshotInfoProperties
    implements JsonSerializable<SiteConfigurationSnapshotInfoProperties> {
    /*
     * The time the snapshot was taken.
     */
    private OffsetDateTime time;

    /*
     * The id of the snapshot
     */
    private Integer snapshotId;

    /**
     * Creates an instance of SiteConfigurationSnapshotInfoProperties class.
     */
    public SiteConfigurationSnapshotInfoProperties() {
    }

    /**
     * Get the time property: The time the snapshot was taken.
     * 
     * @return the time value.
     */
    public OffsetDateTime time() {
        return this.time;
    }

    /**
     * Get the snapshotId property: The id of the snapshot.
     * 
     * @return the snapshotId value.
     */
    public Integer snapshotId() {
        return this.snapshotId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteConfigurationSnapshotInfoProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteConfigurationSnapshotInfoProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SiteConfigurationSnapshotInfoProperties.
     */
    public static SiteConfigurationSnapshotInfoProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteConfigurationSnapshotInfoProperties deserializedSiteConfigurationSnapshotInfoProperties
                = new SiteConfigurationSnapshotInfoProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("time".equals(fieldName)) {
                    deserializedSiteConfigurationSnapshotInfoProperties.time = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("snapshotId".equals(fieldName)) {
                    deserializedSiteConfigurationSnapshotInfoProperties.snapshotId
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteConfigurationSnapshotInfoProperties;
        });
    }
}
