// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Defines values for CustomDnsSuffixProvisioningState.
 */
public enum CustomDnsSuffixProvisioningState {
    /**
     * Enum value Succeeded.
     */
    SUCCEEDED("Succeeded"),

    /**
     * Enum value Failed.
     */
    FAILED("Failed"),

    /**
     * Enum value Degraded.
     */
    DEGRADED("Degraded"),

    /**
     * Enum value InProgress.
     */
    IN_PROGRESS("InProgress");

    /**
     * The actual serialized value for a CustomDnsSuffixProvisioningState instance.
     */
    private final String value;

    CustomDnsSuffixProvisioningState(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CustomDnsSuffixProvisioningState instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CustomDnsSuffixProvisioningState object, or null if unable to parse.
     */
    public static CustomDnsSuffixProvisioningState fromString(String value) {
        if (value == null) {
            return null;
        }
        CustomDnsSuffixProvisioningState[] items = CustomDnsSuffixProvisioningState.values();
        for (CustomDnsSuffixProvisioningState item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
