// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.MigrateMySqlRequestProperties;
import java.io.IOException;

/**
 * MySQL migration request.
 */
@Fluent
public final class MigrateMySqlRequest extends ProxyOnlyResource {
    /*
     * MigrateMySqlRequest resource specific properties
     */
    private MigrateMySqlRequestProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of MigrateMySqlRequest class.
     */
    public MigrateMySqlRequest() {
    }

    /**
     * Get the innerProperties property: MigrateMySqlRequest resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private MigrateMySqlRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public MigrateMySqlRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the connectionString property: Connection string to the remote MySQL database.
     * 
     * @return the connectionString value.
     */
    public String connectionString() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionString();
    }

    /**
     * Set the connectionString property: Connection string to the remote MySQL database.
     * 
     * @param connectionString the connectionString value to set.
     * @return the MigrateMySqlRequest object itself.
     */
    public MigrateMySqlRequest withConnectionString(String connectionString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrateMySqlRequestProperties();
        }
        this.innerProperties().withConnectionString(connectionString);
        return this;
    }

    /**
     * Get the migrationType property: The type of migration operation to be done.
     * 
     * @return the migrationType value.
     */
    public MySqlMigrationType migrationType() {
        return this.innerProperties() == null ? null : this.innerProperties().migrationType();
    }

    /**
     * Set the migrationType property: The type of migration operation to be done.
     * 
     * @param migrationType the migrationType value to set.
     * @return the MigrateMySqlRequest object itself.
     */
    public MigrateMySqlRequest withMigrationType(MySqlMigrationType migrationType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new MigrateMySqlRequestProperties();
        }
        this.innerProperties().withMigrationType(migrationType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of MigrateMySqlRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of MigrateMySqlRequest if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the MigrateMySqlRequest.
     */
    public static MigrateMySqlRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MigrateMySqlRequest deserializedMigrateMySqlRequest = new MigrateMySqlRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedMigrateMySqlRequest.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedMigrateMySqlRequest.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedMigrateMySqlRequest.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedMigrateMySqlRequest.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedMigrateMySqlRequest.innerProperties = MigrateMySqlRequestProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMigrateMySqlRequest;
        });
    }
}
