// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.SnapshotRestoreRequestProperties;
import java.io.IOException;

/**
 * Details about app recovery operation.
 */
@Fluent
public final class SnapshotRestoreRequest extends ProxyOnlyResource {
    /*
     * SnapshotRestoreRequest resource specific properties
     */
    private SnapshotRestoreRequestProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of SnapshotRestoreRequest class.
     */
    public SnapshotRestoreRequest() {
    }

    /**
     * Get the innerProperties property: SnapshotRestoreRequest resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private SnapshotRestoreRequestProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public SnapshotRestoreRequest withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the snapshotTime property: Point in time in which the app restore should be done, formatted as a DateTime
     * string.
     * 
     * @return the snapshotTime value.
     */
    public String snapshotTime() {
        return this.innerProperties() == null ? null : this.innerProperties().snapshotTime();
    }

    /**
     * Set the snapshotTime property: Point in time in which the app restore should be done, formatted as a DateTime
     * string.
     * 
     * @param snapshotTime the snapshotTime value to set.
     * @return the SnapshotRestoreRequest object itself.
     */
    public SnapshotRestoreRequest withSnapshotTime(String snapshotTime) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withSnapshotTime(snapshotTime);
        return this;
    }

    /**
     * Get the recoverySource property: Optional. Specifies the web app that snapshot contents will be retrieved from.
     * If empty, the targeted web app will be used as the source.
     * 
     * @return the recoverySource value.
     */
    public SnapshotRecoverySource recoverySource() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverySource();
    }

    /**
     * Set the recoverySource property: Optional. Specifies the web app that snapshot contents will be retrieved from.
     * If empty, the targeted web app will be used as the source.
     * 
     * @param recoverySource the recoverySource value to set.
     * @return the SnapshotRestoreRequest object itself.
     */
    public SnapshotRestoreRequest withRecoverySource(SnapshotRecoverySource recoverySource) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withRecoverySource(recoverySource);
        return this;
    }

    /**
     * Get the overwrite property: If &lt;code&gt;true&lt;/code&gt; the restore operation can overwrite source app;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the overwrite value.
     */
    public Boolean overwrite() {
        return this.innerProperties() == null ? null : this.innerProperties().overwrite();
    }

    /**
     * Set the overwrite property: If &lt;code&gt;true&lt;/code&gt; the restore operation can overwrite source app;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param overwrite the overwrite value to set.
     * @return the SnapshotRestoreRequest object itself.
     */
    public SnapshotRestoreRequest withOverwrite(Boolean overwrite) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withOverwrite(overwrite);
        return this;
    }

    /**
     * Get the recoverConfiguration property: If true, site configuration, in addition to content, will be reverted.
     * 
     * @return the recoverConfiguration value.
     */
    public Boolean recoverConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().recoverConfiguration();
    }

    /**
     * Set the recoverConfiguration property: If true, site configuration, in addition to content, will be reverted.
     * 
     * @param recoverConfiguration the recoverConfiguration value to set.
     * @return the SnapshotRestoreRequest object itself.
     */
    public SnapshotRestoreRequest withRecoverConfiguration(Boolean recoverConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withRecoverConfiguration(recoverConfiguration);
        return this;
    }

    /**
     * Get the ignoreConflictingHostNames property: If true, custom hostname conflicts will be ignored when recovering
     * to a target web app.
     * This setting is only necessary when RecoverConfiguration is enabled.
     * 
     * @return the ignoreConflictingHostNames value.
     */
    public Boolean ignoreConflictingHostNames() {
        return this.innerProperties() == null ? null : this.innerProperties().ignoreConflictingHostNames();
    }

    /**
     * Set the ignoreConflictingHostNames property: If true, custom hostname conflicts will be ignored when recovering
     * to a target web app.
     * This setting is only necessary when RecoverConfiguration is enabled.
     * 
     * @param ignoreConflictingHostNames the ignoreConflictingHostNames value to set.
     * @return the SnapshotRestoreRequest object itself.
     */
    public SnapshotRestoreRequest withIgnoreConflictingHostNames(Boolean ignoreConflictingHostNames) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withIgnoreConflictingHostNames(ignoreConflictingHostNames);
        return this;
    }

    /**
     * Get the useDRSecondary property: If true, the snapshot is retrieved from DRSecondary endpoint.
     * 
     * @return the useDRSecondary value.
     */
    public Boolean useDRSecondary() {
        return this.innerProperties() == null ? null : this.innerProperties().useDRSecondary();
    }

    /**
     * Set the useDRSecondary property: If true, the snapshot is retrieved from DRSecondary endpoint.
     * 
     * @param useDRSecondary the useDRSecondary value to set.
     * @return the SnapshotRestoreRequest object itself.
     */
    public SnapshotRestoreRequest withUseDRSecondary(Boolean useDRSecondary) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SnapshotRestoreRequestProperties();
        }
        this.innerProperties().withUseDRSecondary(useDRSecondary);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SnapshotRestoreRequest from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SnapshotRestoreRequest if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SnapshotRestoreRequest.
     */
    public static SnapshotRestoreRequest fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SnapshotRestoreRequest deserializedSnapshotRestoreRequest = new SnapshotRestoreRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedSnapshotRestoreRequest.innerProperties
                        = SnapshotRestoreRequestProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSnapshotRestoreRequest;
        });
    }
}
