// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteCustomDomainRequestPropertiesArmResourceProperties;
import java.io.IOException;

/**
 * Static Site Custom Domain Request Properties ARM resource.
 */
@Fluent
public final class StaticSiteCustomDomainRequestPropertiesArmResource extends ProxyOnlyResource {
    /*
     * StaticSiteCustomDomainRequestPropertiesARMResource resource specific properties
     */
    private StaticSiteCustomDomainRequestPropertiesArmResourceProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of StaticSiteCustomDomainRequestPropertiesArmResource class.
     */
    public StaticSiteCustomDomainRequestPropertiesArmResource() {
    }

    /**
     * Get the innerProperties property: StaticSiteCustomDomainRequestPropertiesARMResource resource specific
     * properties.
     * 
     * @return the innerProperties value.
     */
    private StaticSiteCustomDomainRequestPropertiesArmResourceProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public StaticSiteCustomDomainRequestPropertiesArmResource withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the validationMethod property: Validation method for adding a custom domain.
     * 
     * @return the validationMethod value.
     */
    public String validationMethod() {
        return this.innerProperties() == null ? null : this.innerProperties().validationMethod();
    }

    /**
     * Set the validationMethod property: Validation method for adding a custom domain.
     * 
     * @param validationMethod the validationMethod value to set.
     * @return the StaticSiteCustomDomainRequestPropertiesArmResource object itself.
     */
    public StaticSiteCustomDomainRequestPropertiesArmResource withValidationMethod(String validationMethod) {
        if (this.innerProperties() == null) {
            this.innerProperties = new StaticSiteCustomDomainRequestPropertiesArmResourceProperties();
        }
        this.innerProperties().withValidationMethod(validationMethod);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteCustomDomainRequestPropertiesArmResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteCustomDomainRequestPropertiesArmResource if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticSiteCustomDomainRequestPropertiesArmResource.
     */
    public static StaticSiteCustomDomainRequestPropertiesArmResource fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteCustomDomainRequestPropertiesArmResource deserializedStaticSiteCustomDomainRequestPropertiesArmResource
                = new StaticSiteCustomDomainRequestPropertiesArmResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedStaticSiteCustomDomainRequestPropertiesArmResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedStaticSiteCustomDomainRequestPropertiesArmResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedStaticSiteCustomDomainRequestPropertiesArmResource.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedStaticSiteCustomDomainRequestPropertiesArmResource.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedStaticSiteCustomDomainRequestPropertiesArmResource.innerProperties
                        = StaticSiteCustomDomainRequestPropertiesArmResourceProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteCustomDomainRequestPropertiesArmResource;
        });
    }
}
