/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceCertificateInner;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import java.io.IOException;
import java.util.Map;

public final class AppServiceCertificateResourceInner
extends Resource {
    private AppServiceCertificateInner innerProperties;
    private String kind;
    private String id;
    private String name;
    private String type;

    private AppServiceCertificateInner innerProperties() {
        return this.innerProperties;
    }

    public String kind() {
        return this.kind;
    }

    public AppServiceCertificateResourceInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public AppServiceCertificateResourceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public AppServiceCertificateResourceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public String keyVaultId() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultId();
    }

    public AppServiceCertificateResourceInner withKeyVaultId(String keyVaultId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceCertificateInner();
        }
        this.innerProperties().withKeyVaultId(keyVaultId);
        return this;
    }

    public String keyVaultSecretName() {
        return this.innerProperties() == null ? null : this.innerProperties().keyVaultSecretName();
    }

    public AppServiceCertificateResourceInner withKeyVaultSecretName(String keyVaultSecretName) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceCertificateInner();
        }
        this.innerProperties().withKeyVaultSecretName(keyVaultSecretName);
        return this;
    }

    public KeyVaultSecretStatus provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static AppServiceCertificateResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (AppServiceCertificateResourceInner)((Object)jsonReader.readObject(reader -> {
            AppServiceCertificateResourceInner deserializedAppServiceCertificateResourceInner = new AppServiceCertificateResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedAppServiceCertificateResourceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.innerProperties = AppServiceCertificateInner.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAppServiceCertificateResourceInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServiceCertificateResourceInner;
        }));
    }
}

