/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.AppServiceEnvironmentInner;
import com.azure.resourcemanager.appservice.fluent.models.AseV3NetworkingConfigurationInner;
import com.azure.resourcemanager.appservice.fluent.models.CustomDnsSuffixConfigurationInner;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.UpgradeAvailability;
import com.azure.resourcemanager.appservice.models.UpgradePreference;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import java.io.IOException;
import java.util.List;

public final class AppServiceEnvironmentPatchResourceInner
extends ProxyOnlyResource {
    private AppServiceEnvironmentInner innerProperties;
    private String id;
    private String name;
    private String type;

    private AppServiceEnvironmentInner innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public AppServiceEnvironmentPatchResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public HostingEnvironmentStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public VirtualNetworkProfile virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    public AppServiceEnvironmentPatchResourceInner withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    public LoadBalancingMode internalLoadBalancingMode() {
        return this.innerProperties() == null ? null : this.innerProperties().internalLoadBalancingMode();
    }

    public AppServiceEnvironmentPatchResourceInner withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withInternalLoadBalancingMode(internalLoadBalancingMode);
        return this;
    }

    public String multiSize() {
        return this.innerProperties() == null ? null : this.innerProperties().multiSize();
    }

    public AppServiceEnvironmentPatchResourceInner withMultiSize(String multiSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withMultiSize(multiSize);
        return this;
    }

    public Integer multiRoleCount() {
        return this.innerProperties() == null ? null : this.innerProperties().multiRoleCount();
    }

    public Integer ipsslAddressCount() {
        return this.innerProperties() == null ? null : this.innerProperties().ipsslAddressCount();
    }

    public AppServiceEnvironmentPatchResourceInner withIpsslAddressCount(Integer ipsslAddressCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withIpsslAddressCount(ipsslAddressCount);
        return this;
    }

    public String dnsSuffix() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSuffix();
    }

    public AppServiceEnvironmentPatchResourceInner withDnsSuffix(String dnsSuffix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withDnsSuffix(dnsSuffix);
        return this;
    }

    public Integer maximumNumberOfMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumNumberOfMachines();
    }

    public Integer frontEndScaleFactor() {
        return this.innerProperties() == null ? null : this.innerProperties().frontEndScaleFactor();
    }

    public AppServiceEnvironmentPatchResourceInner withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withFrontEndScaleFactor(frontEndScaleFactor);
        return this;
    }

    public Boolean suspended() {
        return this.innerProperties() == null ? null : this.innerProperties().suspended();
    }

    public List<NameValuePair> clusterSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterSettings();
    }

    public AppServiceEnvironmentPatchResourceInner withClusterSettings(List<NameValuePair> clusterSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withClusterSettings(clusterSettings);
        return this;
    }

    public List<String> userWhitelistedIpRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().userWhitelistedIpRanges();
    }

    public AppServiceEnvironmentPatchResourceInner withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withUserWhitelistedIpRanges(userWhitelistedIpRanges);
        return this;
    }

    public Boolean hasLinuxWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().hasLinuxWorkers();
    }

    public UpgradePreference upgradePreference() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradePreference();
    }

    public AppServiceEnvironmentPatchResourceInner withUpgradePreference(UpgradePreference upgradePreference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withUpgradePreference(upgradePreference);
        return this;
    }

    public Integer dedicatedHostCount() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedHostCount();
    }

    public AppServiceEnvironmentPatchResourceInner withDedicatedHostCount(Integer dedicatedHostCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withDedicatedHostCount(dedicatedHostCount);
        return this;
    }

    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    public AppServiceEnvironmentPatchResourceInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    public CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().customDnsSuffixConfiguration();
    }

    public AppServiceEnvironmentPatchResourceInner withCustomDnsSuffixConfiguration(CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withCustomDnsSuffixConfiguration(customDnsSuffixConfiguration);
        return this;
    }

    public AseV3NetworkingConfigurationInner networkingConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().networkingConfiguration();
    }

    public AppServiceEnvironmentPatchResourceInner withNetworkingConfiguration(AseV3NetworkingConfigurationInner networkingConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withNetworkingConfiguration(networkingConfiguration);
        return this;
    }

    public UpgradeAvailability upgradeAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradeAvailability();
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static AppServiceEnvironmentPatchResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (AppServiceEnvironmentPatchResourceInner)((Object)jsonReader.readObject(reader -> {
            AppServiceEnvironmentPatchResourceInner deserializedAppServiceEnvironmentPatchResourceInner = new AppServiceEnvironmentPatchResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.innerProperties = AppServiceEnvironmentInner.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAppServiceEnvironmentPatchResourceInner;
        }));
    }
}

