// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.LocalizableString;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

/**
 * Usage of the quota resource.
 */
@Fluent
public final class CsmUsageQuotaInner implements JsonSerializable<CsmUsageQuotaInner> {
    /*
     * Units of measurement for the quota resource.
     */
    private String unit;

    /*
     * Next reset time for the resource counter.
     */
    private OffsetDateTime nextResetTime;

    /*
     * The current value of the resource counter.
     */
    private Long currentValue;

    /*
     * The resource limit.
     */
    private Long limit;

    /*
     * Quota name.
     */
    private LocalizableString name;

    /**
     * Creates an instance of CsmUsageQuotaInner class.
     */
    public CsmUsageQuotaInner() {
    }

    /**
     * Get the unit property: Units of measurement for the quota resource.
     * 
     * @return the unit value.
     */
    public String unit() {
        return this.unit;
    }

    /**
     * Set the unit property: Units of measurement for the quota resource.
     * 
     * @param unit the unit value to set.
     * @return the CsmUsageQuotaInner object itself.
     */
    public CsmUsageQuotaInner withUnit(String unit) {
        this.unit = unit;
        return this;
    }

    /**
     * Get the nextResetTime property: Next reset time for the resource counter.
     * 
     * @return the nextResetTime value.
     */
    public OffsetDateTime nextResetTime() {
        return this.nextResetTime;
    }

    /**
     * Set the nextResetTime property: Next reset time for the resource counter.
     * 
     * @param nextResetTime the nextResetTime value to set.
     * @return the CsmUsageQuotaInner object itself.
     */
    public CsmUsageQuotaInner withNextResetTime(OffsetDateTime nextResetTime) {
        this.nextResetTime = nextResetTime;
        return this;
    }

    /**
     * Get the currentValue property: The current value of the resource counter.
     * 
     * @return the currentValue value.
     */
    public Long currentValue() {
        return this.currentValue;
    }

    /**
     * Set the currentValue property: The current value of the resource counter.
     * 
     * @param currentValue the currentValue value to set.
     * @return the CsmUsageQuotaInner object itself.
     */
    public CsmUsageQuotaInner withCurrentValue(Long currentValue) {
        this.currentValue = currentValue;
        return this;
    }

    /**
     * Get the limit property: The resource limit.
     * 
     * @return the limit value.
     */
    public Long limit() {
        return this.limit;
    }

    /**
     * Set the limit property: The resource limit.
     * 
     * @param limit the limit value to set.
     * @return the CsmUsageQuotaInner object itself.
     */
    public CsmUsageQuotaInner withLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    /**
     * Get the name property: Quota name.
     * 
     * @return the name value.
     */
    public LocalizableString name() {
        return this.name;
    }

    /**
     * Set the name property: Quota name.
     * 
     * @param name the name value to set.
     * @return the CsmUsageQuotaInner object itself.
     */
    public CsmUsageQuotaInner withName(LocalizableString name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() != null) {
            name().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("unit", this.unit);
        jsonWriter.writeStringField("nextResetTime",
            this.nextResetTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.nextResetTime));
        jsonWriter.writeNumberField("currentValue", this.currentValue);
        jsonWriter.writeNumberField("limit", this.limit);
        jsonWriter.writeJsonField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CsmUsageQuotaInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CsmUsageQuotaInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the CsmUsageQuotaInner.
     */
    public static CsmUsageQuotaInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CsmUsageQuotaInner deserializedCsmUsageQuotaInner = new CsmUsageQuotaInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("unit".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.unit = reader.getString();
                } else if ("nextResetTime".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.nextResetTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("currentValue".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.currentValue = reader.getNullable(JsonReader::getLong);
                } else if ("limit".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.limit = reader.getNullable(JsonReader::getLong);
                } else if ("name".equals(fieldName)) {
                    deserializedCsmUsageQuotaInner.name = LocalizableString.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCsmUsageQuotaInner;
        });
    }
}
