// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * App Insights Web App stack settings.
 */
@Immutable
public final class AppInsightsWebAppStackSettings implements JsonSerializable<AppInsightsWebAppStackSettings> {
    /*
     * <code>true</code> if remote Application Insights is supported for the stack; otherwise, <code>false</code>.
     */
    private Boolean isSupported;

    /*
     * <code>true</code> if Application Insights is disabled by default for the stack; otherwise, <code>false</code>.
     */
    private Boolean isDefaultOff;

    /**
     * Creates an instance of AppInsightsWebAppStackSettings class.
     */
    public AppInsightsWebAppStackSettings() {
    }

    /**
     * Get the isSupported property: &lt;code&gt;true&lt;/code&gt; if remote Application Insights is supported for the
     * stack; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isSupported value.
     */
    public Boolean isSupported() {
        return this.isSupported;
    }

    /**
     * Get the isDefaultOff property: &lt;code&gt;true&lt;/code&gt; if Application Insights is disabled by default for
     * the stack; otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isDefaultOff value.
     */
    public Boolean isDefaultOff() {
        return this.isDefaultOff;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppInsightsWebAppStackSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppInsightsWebAppStackSettings if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AppInsightsWebAppStackSettings.
     */
    public static AppInsightsWebAppStackSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppInsightsWebAppStackSettings deserializedAppInsightsWebAppStackSettings
                = new AppInsightsWebAppStackSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("isSupported".equals(fieldName)) {
                    deserializedAppInsightsWebAppStackSettings.isSupported = reader.getNullable(JsonReader::getBoolean);
                } else if ("isDefaultOff".equals(fieldName)) {
                    deserializedAppInsightsWebAppStackSettings.isDefaultOff
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppInsightsWebAppStackSettings;
        });
    }
}
