// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

/**
 * Certificate product type.
 */
public enum CertificateProductType {
    /**
     * Enum value StandardDomainValidatedSsl.
     */
    STANDARD_DOMAIN_VALIDATED_SSL("StandardDomainValidatedSsl"),

    /**
     * Enum value StandardDomainValidatedWildCardSsl.
     */
    STANDARD_DOMAIN_VALIDATED_WILD_CARD_SSL("StandardDomainValidatedWildCardSsl");

    /**
     * The actual serialized value for a CertificateProductType instance.
     */
    private final String value;

    CertificateProductType(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a CertificateProductType instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed CertificateProductType object, or null if unable to parse.
     */
    public static CertificateProductType fromString(String value) {
        if (value == null) {
            return null;
        }
        CertificateProductType[] items = CertificateProductType.values();
        for (CertificateProductType item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
