// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.StaticSiteFunctionOverviewArmResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * Collection of static site functions.
 */
@Fluent
public final class StaticSiteFunctionOverviewCollection
    implements JsonSerializable<StaticSiteFunctionOverviewCollection> {
    /*
     * Collection of resources.
     */
    private List<StaticSiteFunctionOverviewArmResourceInner> value;

    /*
     * Link to next page of resources.
     */
    private String nextLink;

    /**
     * Creates an instance of StaticSiteFunctionOverviewCollection class.
     */
    public StaticSiteFunctionOverviewCollection() {
    }

    /**
     * Get the value property: Collection of resources.
     * 
     * @return the value value.
     */
    public List<StaticSiteFunctionOverviewArmResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Collection of resources.
     * 
     * @param value the value value to set.
     * @return the StaticSiteFunctionOverviewCollection object itself.
     */
    public StaticSiteFunctionOverviewCollection withValue(List<StaticSiteFunctionOverviewArmResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to next page of resources.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model StaticSiteFunctionOverviewCollection"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(StaticSiteFunctionOverviewCollection.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteFunctionOverviewCollection from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteFunctionOverviewCollection if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the StaticSiteFunctionOverviewCollection.
     */
    public static StaticSiteFunctionOverviewCollection fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteFunctionOverviewCollection deserializedStaticSiteFunctionOverviewCollection
                = new StaticSiteFunctionOverviewCollection();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<StaticSiteFunctionOverviewArmResourceInner> value
                        = reader.readArray(reader1 -> StaticSiteFunctionOverviewArmResourceInner.fromJson(reader1));
                    deserializedStaticSiteFunctionOverviewCollection.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedStaticSiteFunctionOverviewCollection.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteFunctionOverviewCollection;
        });
    }
}
