// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * The minimum strength TLS cipher suite allowed for an application.
 */
public final class TlsCipherSuites extends ExpandableStringEnum<TlsCipherSuites> {
    /**
     * Static value TLS_AES_256_GCM_SHA384 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_AES_256_GCM_SHA384 = fromString("TLS_AES_256_GCM_SHA384");

    /**
     * Static value TLS_AES_128_GCM_SHA256 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_AES_128_GCM_SHA256 = fromString("TLS_AES_128_GCM_SHA256");

    /**
     * Static value TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384
        = fromString("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");

    /**
     * Static value TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256
        = fromString("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256");

    /**
     * Static value TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256
        = fromString("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");

    /**
     * Static value TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384
        = fromString("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384");

    /**
     * Static value TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256
        = fromString("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");

    /**
     * Static value TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384
        = fromString("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384");

    /**
     * Static value TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
        = fromString("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256");

    /**
     * Static value TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA
        = fromString("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA");

    /**
     * Static value TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA
        = fromString("TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA");

    /**
     * Static value TLS_RSA_WITH_AES_256_GCM_SHA384 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_RSA_WITH_AES_256_GCM_SHA384 = fromString("TLS_RSA_WITH_AES_256_GCM_SHA384");

    /**
     * Static value TLS_RSA_WITH_AES_128_GCM_SHA256 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_RSA_WITH_AES_128_GCM_SHA256 = fromString("TLS_RSA_WITH_AES_128_GCM_SHA256");

    /**
     * Static value TLS_RSA_WITH_AES_256_CBC_SHA256 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_RSA_WITH_AES_256_CBC_SHA256 = fromString("TLS_RSA_WITH_AES_256_CBC_SHA256");

    /**
     * Static value TLS_RSA_WITH_AES_128_CBC_SHA256 for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_RSA_WITH_AES_128_CBC_SHA256 = fromString("TLS_RSA_WITH_AES_128_CBC_SHA256");

    /**
     * Static value TLS_RSA_WITH_AES_256_CBC_SHA for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_RSA_WITH_AES_256_CBC_SHA = fromString("TLS_RSA_WITH_AES_256_CBC_SHA");

    /**
     * Static value TLS_RSA_WITH_AES_128_CBC_SHA for TlsCipherSuites.
     */
    public static final TlsCipherSuites TLS_RSA_WITH_AES_128_CBC_SHA = fromString("TLS_RSA_WITH_AES_128_CBC_SHA");

    /**
     * Creates a new instance of TlsCipherSuites value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public TlsCipherSuites() {
    }

    /**
     * Creates or finds a TlsCipherSuites from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding TlsCipherSuites.
     */
    public static TlsCipherSuites fromString(String name) {
        return fromString(name, TlsCipherSuites.class);
    }

    /**
     * Gets known TlsCipherSuites values.
     * 
     * @return known TlsCipherSuites values.
     */
    public static Collection<TlsCipherSuites> values() {
        return values(TlsCipherSuites.class);
    }
}
