// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Windows Java Container settings.
 */
@Immutable
public final class WindowsJavaContainerSettings implements JsonSerializable<WindowsJavaContainerSettings> {
    /*
     * Java container (runtime only).
     */
    private String javaContainer;

    /*
     * Java container version (runtime only).
     */
    private String javaContainerVersion;

    /*
     * <code>true</code> if the stack is in preview; otherwise, <code>false</code>.
     */
    private Boolean isPreview;

    /*
     * <code>true</code> if the stack is deprecated; otherwise, <code>false</code>.
     */
    private Boolean isDeprecated;

    /*
     * <code>true</code> if the stack should be hidden; otherwise, <code>false</code>.
     */
    private Boolean isHidden;

    /*
     * End-of-life date for the minor version.
     */
    private OffsetDateTime endOfLifeDate;

    /*
     * <code>true</code> if the stack version is auto-updated; otherwise, <code>false</code>.
     */
    private Boolean isAutoUpdate;

    /*
     * <code>true</code> if the minor version is early-access; otherwise, <code>false</code>.
     */
    private Boolean isEarlyAccess;

    /**
     * Creates an instance of WindowsJavaContainerSettings class.
     */
    public WindowsJavaContainerSettings() {
    }

    /**
     * Get the javaContainer property: Java container (runtime only).
     * 
     * @return the javaContainer value.
     */
    public String javaContainer() {
        return this.javaContainer;
    }

    /**
     * Get the javaContainerVersion property: Java container version (runtime only).
     * 
     * @return the javaContainerVersion value.
     */
    public String javaContainerVersion() {
        return this.javaContainerVersion;
    }

    /**
     * Get the isPreview property: &lt;code&gt;true&lt;/code&gt; if the stack is in preview; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isPreview value.
     */
    public Boolean isPreview() {
        return this.isPreview;
    }

    /**
     * Get the isDeprecated property: &lt;code&gt;true&lt;/code&gt; if the stack is deprecated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isDeprecated value.
     */
    public Boolean isDeprecated() {
        return this.isDeprecated;
    }

    /**
     * Get the isHidden property: &lt;code&gt;true&lt;/code&gt; if the stack should be hidden; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isHidden value.
     */
    public Boolean isHidden() {
        return this.isHidden;
    }

    /**
     * Get the endOfLifeDate property: End-of-life date for the minor version.
     * 
     * @return the endOfLifeDate value.
     */
    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    /**
     * Get the isAutoUpdate property: &lt;code&gt;true&lt;/code&gt; if the stack version is auto-updated; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isAutoUpdate value.
     */
    public Boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    /**
     * Get the isEarlyAccess property: &lt;code&gt;true&lt;/code&gt; if the minor version is early-access; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the isEarlyAccess value.
     */
    public Boolean isEarlyAccess() {
        return this.isEarlyAccess;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WindowsJavaContainerSettings from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WindowsJavaContainerSettings if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WindowsJavaContainerSettings.
     */
    public static WindowsJavaContainerSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WindowsJavaContainerSettings deserializedWindowsJavaContainerSettings = new WindowsJavaContainerSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("javaContainer".equals(fieldName)) {
                    deserializedWindowsJavaContainerSettings.javaContainer = reader.getString();
                } else if ("javaContainerVersion".equals(fieldName)) {
                    deserializedWindowsJavaContainerSettings.javaContainerVersion = reader.getString();
                } else if ("isPreview".equals(fieldName)) {
                    deserializedWindowsJavaContainerSettings.isPreview = reader.getNullable(JsonReader::getBoolean);
                } else if ("isDeprecated".equals(fieldName)) {
                    deserializedWindowsJavaContainerSettings.isDeprecated = reader.getNullable(JsonReader::getBoolean);
                } else if ("isHidden".equals(fieldName)) {
                    deserializedWindowsJavaContainerSettings.isHidden = reader.getNullable(JsonReader::getBoolean);
                } else if ("endOfLifeDate".equals(fieldName)) {
                    deserializedWindowsJavaContainerSettings.endOfLifeDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("isAutoUpdate".equals(fieldName)) {
                    deserializedWindowsJavaContainerSettings.isAutoUpdate = reader.getNullable(JsonReader::getBoolean);
                } else if ("isEarlyAccess".equals(fieldName)) {
                    deserializedWindowsJavaContainerSettings.isEarlyAccess = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWindowsJavaContainerSettings;
        });
    }
}
