/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.StaticSiteBuildProperties;
import java.io.IOException;

public final class StaticSitesWorkflowPreviewRequestProperties
implements JsonSerializable<StaticSitesWorkflowPreviewRequestProperties> {
    private String repositoryUrl;
    private String branch;
    private StaticSiteBuildProperties buildProperties;

    public String repositoryUrl() {
        return this.repositoryUrl;
    }

    public StaticSitesWorkflowPreviewRequestProperties withRepositoryUrl(String repositoryUrl) {
        this.repositoryUrl = repositoryUrl;
        return this;
    }

    public String branch() {
        return this.branch;
    }

    public StaticSitesWorkflowPreviewRequestProperties withBranch(String branch) {
        this.branch = branch;
        return this;
    }

    public StaticSiteBuildProperties buildProperties() {
        return this.buildProperties;
    }

    public StaticSitesWorkflowPreviewRequestProperties withBuildProperties(StaticSiteBuildProperties buildProperties) {
        this.buildProperties = buildProperties;
        return this;
    }

    public void validate() {
        if (this.buildProperties() != null) {
            this.buildProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("repositoryUrl", this.repositoryUrl);
        jsonWriter.writeStringField("branch", this.branch);
        jsonWriter.writeJsonField("buildProperties", (JsonSerializable)this.buildProperties);
        return jsonWriter.writeEndObject();
    }

    public static StaticSitesWorkflowPreviewRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return (StaticSitesWorkflowPreviewRequestProperties)jsonReader.readObject(reader -> {
            StaticSitesWorkflowPreviewRequestProperties deserializedStaticSitesWorkflowPreviewRequestProperties = new StaticSitesWorkflowPreviewRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("repositoryUrl".equals(fieldName)) {
                    deserializedStaticSitesWorkflowPreviewRequestProperties.repositoryUrl = reader.getString();
                    continue;
                }
                if ("branch".equals(fieldName)) {
                    deserializedStaticSitesWorkflowPreviewRequestProperties.branch = reader.getString();
                    continue;
                }
                if ("buildProperties".equals(fieldName)) {
                    deserializedStaticSitesWorkflowPreviewRequestProperties.buildProperties = StaticSiteBuildProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStaticSitesWorkflowPreviewRequestProperties;
        });
    }
}

