/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class UserProperties
implements JsonSerializable<UserProperties> {
    private String publishingUsername;
    private String publishingPassword;
    private String publishingPasswordHash;
    private String publishingPasswordHashSalt;
    private String scmUri;
    private static final ClientLogger LOGGER = new ClientLogger(UserProperties.class);

    public String publishingUsername() {
        return this.publishingUsername;
    }

    public UserProperties withPublishingUsername(String publishingUsername) {
        this.publishingUsername = publishingUsername;
        return this;
    }

    public String publishingPassword() {
        return this.publishingPassword;
    }

    public UserProperties withPublishingPassword(String publishingPassword) {
        this.publishingPassword = publishingPassword;
        return this;
    }

    public String publishingPasswordHash() {
        return this.publishingPasswordHash;
    }

    public UserProperties withPublishingPasswordHash(String publishingPasswordHash) {
        this.publishingPasswordHash = publishingPasswordHash;
        return this;
    }

    public String publishingPasswordHashSalt() {
        return this.publishingPasswordHashSalt;
    }

    public UserProperties withPublishingPasswordHashSalt(String publishingPasswordHashSalt) {
        this.publishingPasswordHashSalt = publishingPasswordHashSalt;
        return this;
    }

    public String scmUri() {
        return this.scmUri;
    }

    public UserProperties withScmUri(String scmUri) {
        this.scmUri = scmUri;
        return this;
    }

    public void validate() {
        if (this.publishingUsername() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property publishingUsername in model UserProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("publishingUserName", this.publishingUsername);
        jsonWriter.writeStringField("publishingPassword", this.publishingPassword);
        jsonWriter.writeStringField("publishingPasswordHash", this.publishingPasswordHash);
        jsonWriter.writeStringField("publishingPasswordHashSalt", this.publishingPasswordHashSalt);
        jsonWriter.writeStringField("scmUri", this.scmUri);
        return jsonWriter.writeEndObject();
    }

    public static UserProperties fromJson(JsonReader jsonReader) throws IOException {
        return (UserProperties)jsonReader.readObject(reader -> {
            UserProperties deserializedUserProperties = new UserProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("publishingUserName".equals(fieldName)) {
                    deserializedUserProperties.publishingUsername = reader.getString();
                    continue;
                }
                if ("publishingPassword".equals(fieldName)) {
                    deserializedUserProperties.publishingPassword = reader.getString();
                    continue;
                }
                if ("publishingPasswordHash".equals(fieldName)) {
                    deserializedUserProperties.publishingPasswordHash = reader.getString();
                    continue;
                }
                if ("publishingPasswordHashSalt".equals(fieldName)) {
                    deserializedUserProperties.publishingPasswordHashSalt = reader.getString();
                    continue;
                }
                if ("scmUri".equals(fieldName)) {
                    deserializedUserProperties.scmUri = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedUserProperties;
        });
    }
}

