// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.CertificateOrderActionType;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Certificate order action.
 */
@Immutable
public final class CertificateOrderActionInner implements JsonSerializable<CertificateOrderActionInner> {
    /*
     * Action type.
     */
    private CertificateOrderActionType actionType;

    /*
     * Time at which the certificate action was performed.
     */
    private OffsetDateTime createdAt;

    /**
     * Creates an instance of CertificateOrderActionInner class.
     */
    public CertificateOrderActionInner() {
    }

    /**
     * Get the actionType property: Action type.
     * 
     * @return the actionType value.
     */
    public CertificateOrderActionType actionType() {
        return this.actionType;
    }

    /**
     * Get the createdAt property: Time at which the certificate action was performed.
     * 
     * @return the createdAt value.
     */
    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateOrderActionInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateOrderActionInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateOrderActionInner.
     */
    public static CertificateOrderActionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateOrderActionInner deserializedCertificateOrderActionInner = new CertificateOrderActionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("actionType".equals(fieldName)) {
                    deserializedCertificateOrderActionInner.actionType
                        = CertificateOrderActionType.fromString(reader.getString());
                } else if ("createdAt".equals(fieldName)) {
                    deserializedCertificateOrderActionInner.createdAt = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateOrderActionInner;
        });
    }
}
