// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;

/**
 * A domain specific resource identifier.
 */
@Fluent
public final class IdentifierInner extends ProxyOnlyResource {
    /*
     * Identifier resource specific properties
     */
    private IdentifierProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of IdentifierInner class.
     */
    public IdentifierInner() {
    }

    /**
     * Get the innerProperties property: Identifier resource specific properties.
     * 
     * @return the innerProperties value.
     */
    private IdentifierProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IdentifierInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the value property: String representation of the identity.
     * 
     * @return the value value.
     */
    public String value() {
        return this.innerProperties() == null ? null : this.innerProperties().value();
    }

    /**
     * Set the value property: String representation of the identity.
     * 
     * @param value the value value to set.
     * @return the IdentifierInner object itself.
     */
    public IdentifierInner withValue(String value) {
        if (this.innerProperties() == null) {
            this.innerProperties = new IdentifierProperties();
        }
        this.innerProperties().withValue(value);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IdentifierInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IdentifierInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IdentifierInner.
     */
    public static IdentifierInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IdentifierInner deserializedIdentifierInner = new IdentifierInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedIdentifierInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedIdentifierInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedIdentifierInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedIdentifierInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedIdentifierInner.innerProperties = IdentifierProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIdentifierInner;
        });
    }
}
