// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * StaticSiteUserInvitationResponseResource resource specific properties.
 */
@Immutable
public final class StaticSiteUserInvitationResponseResourceProperties
    implements JsonSerializable<StaticSiteUserInvitationResponseResourceProperties> {
    /*
     * The expiration time of the invitation
     */
    private OffsetDateTime expiresOn;

    /*
     * The url for the invitation link
     */
    private String invitationUrl;

    /**
     * Creates an instance of StaticSiteUserInvitationResponseResourceProperties class.
     */
    public StaticSiteUserInvitationResponseResourceProperties() {
    }

    /**
     * Get the expiresOn property: The expiration time of the invitation.
     * 
     * @return the expiresOn value.
     */
    public OffsetDateTime expiresOn() {
        return this.expiresOn;
    }

    /**
     * Get the invitationUrl property: The url for the invitation link.
     * 
     * @return the invitationUrl value.
     */
    public String invitationUrl() {
        return this.invitationUrl;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of StaticSiteUserInvitationResponseResourceProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of StaticSiteUserInvitationResponseResourceProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the StaticSiteUserInvitationResponseResourceProperties.
     */
    public static StaticSiteUserInvitationResponseResourceProperties fromJson(JsonReader jsonReader)
        throws IOException {
        return jsonReader.readObject(reader -> {
            StaticSiteUserInvitationResponseResourceProperties deserializedStaticSiteUserInvitationResponseResourceProperties
                = new StaticSiteUserInvitationResponseResourceProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("expiresOn".equals(fieldName)) {
                    deserializedStaticSiteUserInvitationResponseResourceProperties.expiresOn = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("invitationUrl".equals(fieldName)) {
                    deserializedStaticSiteUserInvitationResponseResourceProperties.invitationUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedStaticSiteUserInvitationResponseResourceProperties;
        });
    }
}
