// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentStatus;
import com.azure.resourcemanager.appservice.models.LoadBalancingMode;
import com.azure.resourcemanager.appservice.models.NameValuePair;
import com.azure.resourcemanager.appservice.models.ProvisioningState;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import com.azure.resourcemanager.appservice.models.UpgradeAvailability;
import com.azure.resourcemanager.appservice.models.UpgradePreference;
import com.azure.resourcemanager.appservice.models.VirtualNetworkProfile;
import java.io.IOException;
import java.util.List;

/**
 * ARM resource for a app service environment.
 */
@Fluent
public final class AppServiceEnvironmentPatchResourceInner extends ProxyOnlyResource {
    /*
     * Core resource properties
     */
    private AppServiceEnvironmentInner innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AppServiceEnvironmentPatchResourceInner class.
     */
    public AppServiceEnvironmentPatchResourceInner() {
    }

    /**
     * Get the innerProperties property: Core resource properties.
     * 
     * @return the innerProperties value.
     */
    private AppServiceEnvironmentInner innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AppServiceEnvironmentPatchResourceInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    /**
     * Get the provisioningState property: Provisioning state of the App Service Environment.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the status property: Current status of the App Service Environment.
     * 
     * @return the status value.
     */
    public HostingEnvironmentStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    /**
     * Get the virtualNetwork property: Description of the Virtual Network.
     * 
     * @return the virtualNetwork value.
     */
    public VirtualNetworkProfile virtualNetwork() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetwork();
    }

    /**
     * Set the virtualNetwork property: Description of the Virtual Network.
     * 
     * @param virtualNetwork the virtualNetwork value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withVirtualNetwork(VirtualNetworkProfile virtualNetwork) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withVirtualNetwork(virtualNetwork);
        return this;
    }

    /**
     * Get the internalLoadBalancingMode property: Specifies which endpoints to serve internally in the Virtual Network
     * for the App Service Environment.
     * 
     * @return the internalLoadBalancingMode value.
     */
    public LoadBalancingMode internalLoadBalancingMode() {
        return this.innerProperties() == null ? null : this.innerProperties().internalLoadBalancingMode();
    }

    /**
     * Set the internalLoadBalancingMode property: Specifies which endpoints to serve internally in the Virtual Network
     * for the App Service Environment.
     * 
     * @param internalLoadBalancingMode the internalLoadBalancingMode value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner
        withInternalLoadBalancingMode(LoadBalancingMode internalLoadBalancingMode) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withInternalLoadBalancingMode(internalLoadBalancingMode);
        return this;
    }

    /**
     * Get the multiSize property: Front-end VM size, e.g. "Medium", "Large".
     * 
     * @return the multiSize value.
     */
    public String multiSize() {
        return this.innerProperties() == null ? null : this.innerProperties().multiSize();
    }

    /**
     * Set the multiSize property: Front-end VM size, e.g. "Medium", "Large".
     * 
     * @param multiSize the multiSize value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withMultiSize(String multiSize) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withMultiSize(multiSize);
        return this;
    }

    /**
     * Get the multiRoleCount property: Number of front-end instances.
     * 
     * @return the multiRoleCount value.
     */
    public Integer multiRoleCount() {
        return this.innerProperties() == null ? null : this.innerProperties().multiRoleCount();
    }

    /**
     * Get the ipsslAddressCount property: Number of IP SSL addresses reserved for the App Service Environment.
     * 
     * @return the ipsslAddressCount value.
     */
    public Integer ipsslAddressCount() {
        return this.innerProperties() == null ? null : this.innerProperties().ipsslAddressCount();
    }

    /**
     * Set the ipsslAddressCount property: Number of IP SSL addresses reserved for the App Service Environment.
     * 
     * @param ipsslAddressCount the ipsslAddressCount value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withIpsslAddressCount(Integer ipsslAddressCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withIpsslAddressCount(ipsslAddressCount);
        return this;
    }

    /**
     * Get the dnsSuffix property: DNS suffix of the App Service Environment.
     * 
     * @return the dnsSuffix value.
     */
    public String dnsSuffix() {
        return this.innerProperties() == null ? null : this.innerProperties().dnsSuffix();
    }

    /**
     * Set the dnsSuffix property: DNS suffix of the App Service Environment.
     * 
     * @param dnsSuffix the dnsSuffix value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withDnsSuffix(String dnsSuffix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withDnsSuffix(dnsSuffix);
        return this;
    }

    /**
     * Get the maximumNumberOfMachines property: Maximum number of VMs in the App Service Environment.
     * 
     * @return the maximumNumberOfMachines value.
     */
    public Integer maximumNumberOfMachines() {
        return this.innerProperties() == null ? null : this.innerProperties().maximumNumberOfMachines();
    }

    /**
     * Get the frontEndScaleFactor property: Scale factor for front-ends.
     * 
     * @return the frontEndScaleFactor value.
     */
    public Integer frontEndScaleFactor() {
        return this.innerProperties() == null ? null : this.innerProperties().frontEndScaleFactor();
    }

    /**
     * Set the frontEndScaleFactor property: Scale factor for front-ends.
     * 
     * @param frontEndScaleFactor the frontEndScaleFactor value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withFrontEndScaleFactor(Integer frontEndScaleFactor) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withFrontEndScaleFactor(frontEndScaleFactor);
        return this;
    }

    /**
     * Get the suspended property: &lt;code&gt;true&lt;/code&gt; if the App Service Environment is suspended; otherwise,
     * &lt;code&gt;false&lt;/code&gt;. The environment can be suspended, e.g. when the management endpoint is no longer
     * available
     * (most likely because NSG blocked the incoming traffic).
     * 
     * @return the suspended value.
     */
    public Boolean suspended() {
        return this.innerProperties() == null ? null : this.innerProperties().suspended();
    }

    /**
     * Get the clusterSettings property: Custom settings for changing the behavior of the App Service Environment.
     * 
     * @return the clusterSettings value.
     */
    public List<NameValuePair> clusterSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().clusterSettings();
    }

    /**
     * Set the clusterSettings property: Custom settings for changing the behavior of the App Service Environment.
     * 
     * @param clusterSettings the clusterSettings value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withClusterSettings(List<NameValuePair> clusterSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withClusterSettings(clusterSettings);
        return this;
    }

    /**
     * Get the userWhitelistedIpRanges property: User added ip ranges to whitelist on ASE db.
     * 
     * @return the userWhitelistedIpRanges value.
     */
    public List<String> userWhitelistedIpRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().userWhitelistedIpRanges();
    }

    /**
     * Set the userWhitelistedIpRanges property: User added ip ranges to whitelist on ASE db.
     * 
     * @param userWhitelistedIpRanges the userWhitelistedIpRanges value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withUserWhitelistedIpRanges(List<String> userWhitelistedIpRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withUserWhitelistedIpRanges(userWhitelistedIpRanges);
        return this;
    }

    /**
     * Get the hasLinuxWorkers property: Flag that displays whether an ASE has linux workers or not.
     * 
     * @return the hasLinuxWorkers value.
     */
    public Boolean hasLinuxWorkers() {
        return this.innerProperties() == null ? null : this.innerProperties().hasLinuxWorkers();
    }

    /**
     * Get the upgradePreference property: Upgrade Preference.
     * 
     * @return the upgradePreference value.
     */
    public UpgradePreference upgradePreference() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradePreference();
    }

    /**
     * Set the upgradePreference property: Upgrade Preference.
     * 
     * @param upgradePreference the upgradePreference value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withUpgradePreference(UpgradePreference upgradePreference) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withUpgradePreference(upgradePreference);
        return this;
    }

    /**
     * Get the dedicatedHostCount property: Dedicated Host Count.
     * 
     * @return the dedicatedHostCount value.
     */
    public Integer dedicatedHostCount() {
        return this.innerProperties() == null ? null : this.innerProperties().dedicatedHostCount();
    }

    /**
     * Set the dedicatedHostCount property: Dedicated Host Count.
     * 
     * @param dedicatedHostCount the dedicatedHostCount value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withDedicatedHostCount(Integer dedicatedHostCount) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withDedicatedHostCount(dedicatedHostCount);
        return this;
    }

    /**
     * Get the zoneRedundant property: Whether or not this App Service Environment is zone-redundant.
     * 
     * @return the zoneRedundant value.
     */
    public Boolean zoneRedundant() {
        return this.innerProperties() == null ? null : this.innerProperties().zoneRedundant();
    }

    /**
     * Set the zoneRedundant property: Whether or not this App Service Environment is zone-redundant.
     * 
     * @param zoneRedundant the zoneRedundant value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner withZoneRedundant(Boolean zoneRedundant) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withZoneRedundant(zoneRedundant);
        return this;
    }

    /**
     * Get the customDnsSuffixConfiguration property: Full view of the custom domain suffix configuration for ASEv3.
     * 
     * @return the customDnsSuffixConfiguration value.
     */
    public CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().customDnsSuffixConfiguration();
    }

    /**
     * Set the customDnsSuffixConfiguration property: Full view of the custom domain suffix configuration for ASEv3.
     * 
     * @param customDnsSuffixConfiguration the customDnsSuffixConfiguration value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner
        withCustomDnsSuffixConfiguration(CustomDnsSuffixConfigurationInner customDnsSuffixConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withCustomDnsSuffixConfiguration(customDnsSuffixConfiguration);
        return this;
    }

    /**
     * Get the networkingConfiguration property: Full view of networking configuration for an ASE.
     * 
     * @return the networkingConfiguration value.
     */
    public AseV3NetworkingConfigurationInner networkingConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().networkingConfiguration();
    }

    /**
     * Set the networkingConfiguration property: Full view of networking configuration for an ASE.
     * 
     * @param networkingConfiguration the networkingConfiguration value to set.
     * @return the AppServiceEnvironmentPatchResourceInner object itself.
     */
    public AppServiceEnvironmentPatchResourceInner
        withNetworkingConfiguration(AseV3NetworkingConfigurationInner networkingConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AppServiceEnvironmentInner();
        }
        this.innerProperties().withNetworkingConfiguration(networkingConfiguration);
        return this;
    }

    /**
     * Get the upgradeAvailability property: Whether an upgrade is available for this App Service Environment.
     * 
     * @return the upgradeAvailability value.
     */
    public UpgradeAvailability upgradeAvailability() {
        return this.innerProperties() == null ? null : this.innerProperties().upgradeAvailability();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", kind());
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AppServiceEnvironmentPatchResourceInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AppServiceEnvironmentPatchResourceInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AppServiceEnvironmentPatchResourceInner.
     */
    public static AppServiceEnvironmentPatchResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AppServiceEnvironmentPatchResourceInner deserializedAppServiceEnvironmentPatchResourceInner
                = new AppServiceEnvironmentPatchResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.type = reader.getString();
                } else if ("kind".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.withKind(reader.getString());
                } else if ("properties".equals(fieldName)) {
                    deserializedAppServiceEnvironmentPatchResourceInner.innerProperties
                        = AppServiceEnvironmentInner.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAppServiceEnvironmentPatchResourceInner;
        });
    }
}
