// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The azure resource error info.
 */
@Fluent
public final class AzureResourceErrorInfo extends ErrorInfo {
    /*
     * The error message.
     */
    private String message;

    /*
     * The error details.
     */
    private List<AzureResourceErrorInfo> details;

    /**
     * Creates an instance of AzureResourceErrorInfo class.
     */
    public AzureResourceErrorInfo() {
    }

    /**
     * Get the message property: The error message.
     * 
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Set the message property: The error message.
     * 
     * @param message the message value to set.
     * @return the AzureResourceErrorInfo object itself.
     */
    public AzureResourceErrorInfo withMessage(String message) {
        this.message = message;
        return this;
    }

    /**
     * Get the details property: The error details.
     * 
     * @return the details value.
     */
    public List<AzureResourceErrorInfo> details() {
        return this.details;
    }

    /**
     * Set the details property: The error details.
     * 
     * @param details the details value to set.
     * @return the AzureResourceErrorInfo object itself.
     */
    public AzureResourceErrorInfo withDetails(List<AzureResourceErrorInfo> details) {
        this.details = details;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AzureResourceErrorInfo withCode(String code) {
        super.withCode(code);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (message() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property message in model AzureResourceErrorInfo"));
        }
        if (details() != null) {
            details().forEach(e -> e.validate());
        }
        if (code() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property code in model AzureResourceErrorInfo"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(AzureResourceErrorInfo.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", code());
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureResourceErrorInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureResourceErrorInfo if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AzureResourceErrorInfo.
     */
    public static AzureResourceErrorInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureResourceErrorInfo deserializedAzureResourceErrorInfo = new AzureResourceErrorInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("code".equals(fieldName)) {
                    deserializedAzureResourceErrorInfo.withCode(reader.getString());
                } else if ("message".equals(fieldName)) {
                    deserializedAzureResourceErrorInfo.message = reader.getString();
                } else if ("details".equals(fieldName)) {
                    List<AzureResourceErrorInfo> details
                        = reader.readArray(reader1 -> AzureResourceErrorInfo.fromJson(reader1));
                    deserializedAzureResourceErrorInfo.details = details;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureResourceErrorInfo;
        });
    }
}
