// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Azure Files or Blob Storage access information value for dictionary storage.
 */
@Fluent
public final class AzureStorageInfoValue implements JsonSerializable<AzureStorageInfoValue> {
    /*
     * Type of storage.
     */
    private AzureStorageType type;

    /*
     * Name of the storage account.
     */
    private String accountName;

    /*
     * Name of the file share (container name, for Blob storage).
     */
    private String shareName;

    /*
     * Access key for the storage account.
     */
    private String accessKey;

    /*
     * Path to mount the storage within the site's runtime environment.
     */
    private String mountPath;

    /*
     * State of the storage account.
     */
    private AzureStorageState state;

    /*
     * Mounting protocol to use for the storage account.
     */
    private AzureStorageProtocol protocol;

    /**
     * Creates an instance of AzureStorageInfoValue class.
     */
    public AzureStorageInfoValue() {
    }

    /**
     * Get the type property: Type of storage.
     * 
     * @return the type value.
     */
    public AzureStorageType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of storage.
     * 
     * @param type the type value to set.
     * @return the AzureStorageInfoValue object itself.
     */
    public AzureStorageInfoValue withType(AzureStorageType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the accountName property: Name of the storage account.
     * 
     * @return the accountName value.
     */
    public String accountName() {
        return this.accountName;
    }

    /**
     * Set the accountName property: Name of the storage account.
     * 
     * @param accountName the accountName value to set.
     * @return the AzureStorageInfoValue object itself.
     */
    public AzureStorageInfoValue withAccountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    /**
     * Get the shareName property: Name of the file share (container name, for Blob storage).
     * 
     * @return the shareName value.
     */
    public String shareName() {
        return this.shareName;
    }

    /**
     * Set the shareName property: Name of the file share (container name, for Blob storage).
     * 
     * @param shareName the shareName value to set.
     * @return the AzureStorageInfoValue object itself.
     */
    public AzureStorageInfoValue withShareName(String shareName) {
        this.shareName = shareName;
        return this;
    }

    /**
     * Get the accessKey property: Access key for the storage account.
     * 
     * @return the accessKey value.
     */
    public String accessKey() {
        return this.accessKey;
    }

    /**
     * Set the accessKey property: Access key for the storage account.
     * 
     * @param accessKey the accessKey value to set.
     * @return the AzureStorageInfoValue object itself.
     */
    public AzureStorageInfoValue withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    /**
     * Get the mountPath property: Path to mount the storage within the site's runtime environment.
     * 
     * @return the mountPath value.
     */
    public String mountPath() {
        return this.mountPath;
    }

    /**
     * Set the mountPath property: Path to mount the storage within the site's runtime environment.
     * 
     * @param mountPath the mountPath value to set.
     * @return the AzureStorageInfoValue object itself.
     */
    public AzureStorageInfoValue withMountPath(String mountPath) {
        this.mountPath = mountPath;
        return this;
    }

    /**
     * Get the state property: State of the storage account.
     * 
     * @return the state value.
     */
    public AzureStorageState state() {
        return this.state;
    }

    /**
     * Get the protocol property: Mounting protocol to use for the storage account.
     * 
     * @return the protocol value.
     */
    public AzureStorageProtocol protocol() {
        return this.protocol;
    }

    /**
     * Set the protocol property: Mounting protocol to use for the storage account.
     * 
     * @param protocol the protocol value to set.
     * @return the AzureStorageInfoValue object itself.
     */
    public AzureStorageInfoValue withProtocol(AzureStorageProtocol protocol) {
        this.protocol = protocol;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("accountName", this.accountName);
        jsonWriter.writeStringField("shareName", this.shareName);
        jsonWriter.writeStringField("accessKey", this.accessKey);
        jsonWriter.writeStringField("mountPath", this.mountPath);
        jsonWriter.writeStringField("protocol", this.protocol == null ? null : this.protocol.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AzureStorageInfoValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AzureStorageInfoValue if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AzureStorageInfoValue.
     */
    public static AzureStorageInfoValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AzureStorageInfoValue deserializedAzureStorageInfoValue = new AzureStorageInfoValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedAzureStorageInfoValue.type = AzureStorageType.fromString(reader.getString());
                } else if ("accountName".equals(fieldName)) {
                    deserializedAzureStorageInfoValue.accountName = reader.getString();
                } else if ("shareName".equals(fieldName)) {
                    deserializedAzureStorageInfoValue.shareName = reader.getString();
                } else if ("accessKey".equals(fieldName)) {
                    deserializedAzureStorageInfoValue.accessKey = reader.getString();
                } else if ("mountPath".equals(fieldName)) {
                    deserializedAzureStorageInfoValue.mountPath = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedAzureStorageInfoValue.state = AzureStorageState.fromString(reader.getString());
                } else if ("protocol".equals(fieldName)) {
                    deserializedAzureStorageInfoValue.protocol = AzureStorageProtocol.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAzureStorageInfoValue;
        });
    }
}
