// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

/**
 * Information needed for cloning operation.
 */
@Fluent
public final class CloningInfo implements JsonSerializable<CloningInfo> {
    /*
     * Correlation ID of cloning operation. This ID ties multiple cloning operations
     * together to use the same snapshot.
     */
    private UUID correlationId;

    /*
     * <code>true</code> to overwrite destination app; otherwise, <code>false</code>.
     */
    private Boolean overwrite;

    /*
     * <code>true</code> to clone custom hostnames from source app; otherwise, <code>false</code>.
     */
    private Boolean cloneCustomHostNames;

    /*
     * <code>true</code> to clone source control from source app; otherwise, <code>false</code>.
     */
    private Boolean cloneSourceControl;

    /*
     * ARM resource ID of the source app. App resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production
     * slots and
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{
     * slotName} for other slots.
     */
    private String sourceWebAppId;

    /*
     * Location of source app ex: West US or North Europe
     */
    private String sourceWebAppLocation;

    /*
     * App Service Environment.
     */
    private String hostingEnvironment;

    /*
     * Application setting overrides for cloned app. If specified, these settings override the settings cloned
     * from source app. Otherwise, application settings from source app are retained.
     */
    private Map<String, String> appSettingsOverrides;

    /*
     * <code>true</code> to configure load balancing for source and destination app.
     */
    private Boolean configureLoadBalancing;

    /*
     * ARM resource ID of the Traffic Manager profile to use, if it exists. Traffic Manager resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{
     * profileName}.
     */
    private String trafficManagerProfileId;

    /*
     * Name of Traffic Manager profile to create. This is only needed if Traffic Manager profile does not already exist.
     */
    private String trafficManagerProfileName;

    /**
     * Creates an instance of CloningInfo class.
     */
    public CloningInfo() {
    }

    /**
     * Get the correlationId property: Correlation ID of cloning operation. This ID ties multiple cloning operations
     * together to use the same snapshot.
     * 
     * @return the correlationId value.
     */
    public UUID correlationId() {
        return this.correlationId;
    }

    /**
     * Set the correlationId property: Correlation ID of cloning operation. This ID ties multiple cloning operations
     * together to use the same snapshot.
     * 
     * @param correlationId the correlationId value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withCorrelationId(UUID correlationId) {
        this.correlationId = correlationId;
        return this;
    }

    /**
     * Get the overwrite property: &lt;code&gt;true&lt;/code&gt; to overwrite destination app; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the overwrite value.
     */
    public Boolean overwrite() {
        return this.overwrite;
    }

    /**
     * Set the overwrite property: &lt;code&gt;true&lt;/code&gt; to overwrite destination app; otherwise,
     * &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param overwrite the overwrite value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withOverwrite(Boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    /**
     * Get the cloneCustomHostNames property: &lt;code&gt;true&lt;/code&gt; to clone custom hostnames from source app;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the cloneCustomHostNames value.
     */
    public Boolean cloneCustomHostNames() {
        return this.cloneCustomHostNames;
    }

    /**
     * Set the cloneCustomHostNames property: &lt;code&gt;true&lt;/code&gt; to clone custom hostnames from source app;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param cloneCustomHostNames the cloneCustomHostNames value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withCloneCustomHostNames(Boolean cloneCustomHostNames) {
        this.cloneCustomHostNames = cloneCustomHostNames;
        return this;
    }

    /**
     * Get the cloneSourceControl property: &lt;code&gt;true&lt;/code&gt; to clone source control from source app;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @return the cloneSourceControl value.
     */
    public Boolean cloneSourceControl() {
        return this.cloneSourceControl;
    }

    /**
     * Set the cloneSourceControl property: &lt;code&gt;true&lt;/code&gt; to clone source control from source app;
     * otherwise, &lt;code&gt;false&lt;/code&gt;.
     * 
     * @param cloneSourceControl the cloneSourceControl value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withCloneSourceControl(Boolean cloneSourceControl) {
        this.cloneSourceControl = cloneSourceControl;
        return this;
    }

    /**
     * Get the sourceWebAppId property: ARM resource ID of the source app. App resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production
     * slots and
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     * for other slots.
     * 
     * @return the sourceWebAppId value.
     */
    public String sourceWebAppId() {
        return this.sourceWebAppId;
    }

    /**
     * Set the sourceWebAppId property: ARM resource ID of the source app. App resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName} for production
     * slots and
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/sites/{siteName}/slots/{slotName}
     * for other slots.
     * 
     * @param sourceWebAppId the sourceWebAppId value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withSourceWebAppId(String sourceWebAppId) {
        this.sourceWebAppId = sourceWebAppId;
        return this;
    }

    /**
     * Get the sourceWebAppLocation property: Location of source app ex: West US or North Europe.
     * 
     * @return the sourceWebAppLocation value.
     */
    public String sourceWebAppLocation() {
        return this.sourceWebAppLocation;
    }

    /**
     * Set the sourceWebAppLocation property: Location of source app ex: West US or North Europe.
     * 
     * @param sourceWebAppLocation the sourceWebAppLocation value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withSourceWebAppLocation(String sourceWebAppLocation) {
        this.sourceWebAppLocation = sourceWebAppLocation;
        return this;
    }

    /**
     * Get the hostingEnvironment property: App Service Environment.
     * 
     * @return the hostingEnvironment value.
     */
    public String hostingEnvironment() {
        return this.hostingEnvironment;
    }

    /**
     * Set the hostingEnvironment property: App Service Environment.
     * 
     * @param hostingEnvironment the hostingEnvironment value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withHostingEnvironment(String hostingEnvironment) {
        this.hostingEnvironment = hostingEnvironment;
        return this;
    }

    /**
     * Get the appSettingsOverrides property: Application setting overrides for cloned app. If specified, these settings
     * override the settings cloned
     * from source app. Otherwise, application settings from source app are retained.
     * 
     * @return the appSettingsOverrides value.
     */
    public Map<String, String> appSettingsOverrides() {
        return this.appSettingsOverrides;
    }

    /**
     * Set the appSettingsOverrides property: Application setting overrides for cloned app. If specified, these settings
     * override the settings cloned
     * from source app. Otherwise, application settings from source app are retained.
     * 
     * @param appSettingsOverrides the appSettingsOverrides value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withAppSettingsOverrides(Map<String, String> appSettingsOverrides) {
        this.appSettingsOverrides = appSettingsOverrides;
        return this;
    }

    /**
     * Get the configureLoadBalancing property: &lt;code&gt;true&lt;/code&gt; to configure load balancing for source and
     * destination app.
     * 
     * @return the configureLoadBalancing value.
     */
    public Boolean configureLoadBalancing() {
        return this.configureLoadBalancing;
    }

    /**
     * Set the configureLoadBalancing property: &lt;code&gt;true&lt;/code&gt; to configure load balancing for source and
     * destination app.
     * 
     * @param configureLoadBalancing the configureLoadBalancing value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withConfigureLoadBalancing(Boolean configureLoadBalancing) {
        this.configureLoadBalancing = configureLoadBalancing;
        return this;
    }

    /**
     * Get the trafficManagerProfileId property: ARM resource ID of the Traffic Manager profile to use, if it exists.
     * Traffic Manager resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
     * 
     * @return the trafficManagerProfileId value.
     */
    public String trafficManagerProfileId() {
        return this.trafficManagerProfileId;
    }

    /**
     * Set the trafficManagerProfileId property: ARM resource ID of the Traffic Manager profile to use, if it exists.
     * Traffic Manager resource ID is of the form
     * /subscriptions/{subId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{profileName}.
     * 
     * @param trafficManagerProfileId the trafficManagerProfileId value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withTrafficManagerProfileId(String trafficManagerProfileId) {
        this.trafficManagerProfileId = trafficManagerProfileId;
        return this;
    }

    /**
     * Get the trafficManagerProfileName property: Name of Traffic Manager profile to create. This is only needed if
     * Traffic Manager profile does not already exist.
     * 
     * @return the trafficManagerProfileName value.
     */
    public String trafficManagerProfileName() {
        return this.trafficManagerProfileName;
    }

    /**
     * Set the trafficManagerProfileName property: Name of Traffic Manager profile to create. This is only needed if
     * Traffic Manager profile does not already exist.
     * 
     * @param trafficManagerProfileName the trafficManagerProfileName value to set.
     * @return the CloningInfo object itself.
     */
    public CloningInfo withTrafficManagerProfileName(String trafficManagerProfileName) {
        this.trafficManagerProfileName = trafficManagerProfileName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (sourceWebAppId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property sourceWebAppId in model CloningInfo"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(CloningInfo.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sourceWebAppId", this.sourceWebAppId);
        jsonWriter.writeStringField("correlationId", Objects.toString(this.correlationId, null));
        jsonWriter.writeBooleanField("overwrite", this.overwrite);
        jsonWriter.writeBooleanField("cloneCustomHostNames", this.cloneCustomHostNames);
        jsonWriter.writeBooleanField("cloneSourceControl", this.cloneSourceControl);
        jsonWriter.writeStringField("sourceWebAppLocation", this.sourceWebAppLocation);
        jsonWriter.writeStringField("hostingEnvironment", this.hostingEnvironment);
        jsonWriter.writeMapField("appSettingsOverrides", this.appSettingsOverrides,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeBooleanField("configureLoadBalancing", this.configureLoadBalancing);
        jsonWriter.writeStringField("trafficManagerProfileId", this.trafficManagerProfileId);
        jsonWriter.writeStringField("trafficManagerProfileName", this.trafficManagerProfileName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CloningInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CloningInfo if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CloningInfo.
     */
    public static CloningInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloningInfo deserializedCloningInfo = new CloningInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceWebAppId".equals(fieldName)) {
                    deserializedCloningInfo.sourceWebAppId = reader.getString();
                } else if ("correlationId".equals(fieldName)) {
                    deserializedCloningInfo.correlationId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("overwrite".equals(fieldName)) {
                    deserializedCloningInfo.overwrite = reader.getNullable(JsonReader::getBoolean);
                } else if ("cloneCustomHostNames".equals(fieldName)) {
                    deserializedCloningInfo.cloneCustomHostNames = reader.getNullable(JsonReader::getBoolean);
                } else if ("cloneSourceControl".equals(fieldName)) {
                    deserializedCloningInfo.cloneSourceControl = reader.getNullable(JsonReader::getBoolean);
                } else if ("sourceWebAppLocation".equals(fieldName)) {
                    deserializedCloningInfo.sourceWebAppLocation = reader.getString();
                } else if ("hostingEnvironment".equals(fieldName)) {
                    deserializedCloningInfo.hostingEnvironment = reader.getString();
                } else if ("appSettingsOverrides".equals(fieldName)) {
                    Map<String, String> appSettingsOverrides = reader.readMap(reader1 -> reader1.getString());
                    deserializedCloningInfo.appSettingsOverrides = appSettingsOverrides;
                } else if ("configureLoadBalancing".equals(fieldName)) {
                    deserializedCloningInfo.configureLoadBalancing = reader.getNullable(JsonReader::getBoolean);
                } else if ("trafficManagerProfileId".equals(fieldName)) {
                    deserializedCloningInfo.trafficManagerProfileId = reader.getString();
                } else if ("trafficManagerProfileName".equals(fieldName)) {
                    deserializedCloningInfo.trafficManagerProfileName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCloningInfo;
        });
    }
}
