// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The configuration settings of the nonce used in the login flow.
 */
@Fluent
public final class Nonce implements JsonSerializable<Nonce> {
    /*
     * <code>false</code> if the nonce should not be validated while completing the login flow; otherwise,
     * <code>true</code>.
     */
    private Boolean validateNonce;

    /*
     * The time after the request is made when the nonce should expire.
     */
    private String nonceExpirationInterval;

    /**
     * Creates an instance of Nonce class.
     */
    public Nonce() {
    }

    /**
     * Get the validateNonce property: &lt;code&gt;false&lt;/code&gt; if the nonce should not be validated while
     * completing the login flow; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @return the validateNonce value.
     */
    public Boolean validateNonce() {
        return this.validateNonce;
    }

    /**
     * Set the validateNonce property: &lt;code&gt;false&lt;/code&gt; if the nonce should not be validated while
     * completing the login flow; otherwise, &lt;code&gt;true&lt;/code&gt;.
     * 
     * @param validateNonce the validateNonce value to set.
     * @return the Nonce object itself.
     */
    public Nonce withValidateNonce(Boolean validateNonce) {
        this.validateNonce = validateNonce;
        return this;
    }

    /**
     * Get the nonceExpirationInterval property: The time after the request is made when the nonce should expire.
     * 
     * @return the nonceExpirationInterval value.
     */
    public String nonceExpirationInterval() {
        return this.nonceExpirationInterval;
    }

    /**
     * Set the nonceExpirationInterval property: The time after the request is made when the nonce should expire.
     * 
     * @param nonceExpirationInterval the nonceExpirationInterval value to set.
     * @return the Nonce object itself.
     */
    public Nonce withNonceExpirationInterval(String nonceExpirationInterval) {
        this.nonceExpirationInterval = nonceExpirationInterval;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("validateNonce", this.validateNonce);
        jsonWriter.writeStringField("nonceExpirationInterval", this.nonceExpirationInterval);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Nonce from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Nonce if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IOException If an error occurs while reading the Nonce.
     */
    public static Nonce fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Nonce deserializedNonce = new Nonce();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("validateNonce".equals(fieldName)) {
                    deserializedNonce.validateNonce = reader.getNullable(JsonReader::getBoolean);
                } else if ("nonceExpirationInterval".equals(fieldName)) {
                    deserializedNonce.nonceExpirationInterval = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedNonce;
        });
    }
}
