// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The correlation properties.
 */
@Fluent
public class RunCorrelation implements JsonSerializable<RunCorrelation> {
    /*
     * The client tracking identifier.
     */
    private String clientTrackingId;

    /*
     * The client keywords.
     */
    private List<String> clientKeywords;

    /**
     * Creates an instance of RunCorrelation class.
     */
    public RunCorrelation() {
    }

    /**
     * Get the clientTrackingId property: The client tracking identifier.
     * 
     * @return the clientTrackingId value.
     */
    public String clientTrackingId() {
        return this.clientTrackingId;
    }

    /**
     * Set the clientTrackingId property: The client tracking identifier.
     * 
     * @param clientTrackingId the clientTrackingId value to set.
     * @return the RunCorrelation object itself.
     */
    public RunCorrelation withClientTrackingId(String clientTrackingId) {
        this.clientTrackingId = clientTrackingId;
        return this;
    }

    /**
     * Get the clientKeywords property: The client keywords.
     * 
     * @return the clientKeywords value.
     */
    public List<String> clientKeywords() {
        return this.clientKeywords;
    }

    /**
     * Set the clientKeywords property: The client keywords.
     * 
     * @param clientKeywords the clientKeywords value to set.
     * @return the RunCorrelation object itself.
     */
    public RunCorrelation withClientKeywords(List<String> clientKeywords) {
        this.clientKeywords = clientKeywords;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("clientTrackingId", this.clientTrackingId);
        jsonWriter.writeArrayField("clientKeywords", this.clientKeywords,
            (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunCorrelation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunCorrelation if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the RunCorrelation.
     */
    public static RunCorrelation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunCorrelation deserializedRunCorrelation = new RunCorrelation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("clientTrackingId".equals(fieldName)) {
                    deserializedRunCorrelation.clientTrackingId = reader.getString();
                } else if ("clientKeywords".equals(fieldName)) {
                    List<String> clientKeywords = reader.readArray(reader1 -> reader1.getString());
                    deserializedRunCorrelation.clientKeywords = clientKeywords;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunCorrelation;
        });
    }
}
