// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Metric limits set on an app.
 */
@Fluent
public final class SiteLimits implements JsonSerializable<SiteLimits> {
    /*
     * Maximum allowed CPU usage percentage.
     */
    private Double maxPercentageCpu;

    /*
     * Maximum allowed memory usage in MB.
     */
    private Long maxMemoryInMb;

    /*
     * Maximum allowed disk size usage in MB.
     */
    private Long maxDiskSizeInMb;

    /**
     * Creates an instance of SiteLimits class.
     */
    public SiteLimits() {
    }

    /**
     * Get the maxPercentageCpu property: Maximum allowed CPU usage percentage.
     * 
     * @return the maxPercentageCpu value.
     */
    public Double maxPercentageCpu() {
        return this.maxPercentageCpu;
    }

    /**
     * Set the maxPercentageCpu property: Maximum allowed CPU usage percentage.
     * 
     * @param maxPercentageCpu the maxPercentageCpu value to set.
     * @return the SiteLimits object itself.
     */
    public SiteLimits withMaxPercentageCpu(Double maxPercentageCpu) {
        this.maxPercentageCpu = maxPercentageCpu;
        return this;
    }

    /**
     * Get the maxMemoryInMb property: Maximum allowed memory usage in MB.
     * 
     * @return the maxMemoryInMb value.
     */
    public Long maxMemoryInMb() {
        return this.maxMemoryInMb;
    }

    /**
     * Set the maxMemoryInMb property: Maximum allowed memory usage in MB.
     * 
     * @param maxMemoryInMb the maxMemoryInMb value to set.
     * @return the SiteLimits object itself.
     */
    public SiteLimits withMaxMemoryInMb(Long maxMemoryInMb) {
        this.maxMemoryInMb = maxMemoryInMb;
        return this;
    }

    /**
     * Get the maxDiskSizeInMb property: Maximum allowed disk size usage in MB.
     * 
     * @return the maxDiskSizeInMb value.
     */
    public Long maxDiskSizeInMb() {
        return this.maxDiskSizeInMb;
    }

    /**
     * Set the maxDiskSizeInMb property: Maximum allowed disk size usage in MB.
     * 
     * @param maxDiskSizeInMb the maxDiskSizeInMb value to set.
     * @return the SiteLimits object itself.
     */
    public SiteLimits withMaxDiskSizeInMb(Long maxDiskSizeInMb) {
        this.maxDiskSizeInMb = maxDiskSizeInMb;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("maxPercentageCpu", this.maxPercentageCpu);
        jsonWriter.writeNumberField("maxMemoryInMb", this.maxMemoryInMb);
        jsonWriter.writeNumberField("maxDiskSizeInMb", this.maxDiskSizeInMb);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SiteLimits from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SiteLimits if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the SiteLimits.
     */
    public static SiteLimits fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SiteLimits deserializedSiteLimits = new SiteLimits();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("maxPercentageCpu".equals(fieldName)) {
                    deserializedSiteLimits.maxPercentageCpu = reader.getNullable(JsonReader::getDouble);
                } else if ("maxMemoryInMb".equals(fieldName)) {
                    deserializedSiteLimits.maxMemoryInMb = reader.getNullable(JsonReader::getLong);
                } else if ("maxDiskSizeInMb".equals(fieldName)) {
                    deserializedSiteLimits.maxDiskSizeInMb = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSiteLimits;
        });
    }
}
