// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Class Representing Solution for problems detected.
 */
@Fluent
public final class Solution implements JsonSerializable<Solution> {
    /*
     * Solution Id.
     */
    private Double id;

    /*
     * Display Name of the solution
     */
    private String displayName;

    /*
     * Order of the solution.
     */
    private Double order;

    /*
     * Description of the solution
     */
    private String description;

    /*
     * Type of Solution
     */
    private SolutionType type;

    /*
     * Solution Data.
     */
    private List<List<NameValuePair>> data;

    /*
     * Solution Metadata.
     */
    private List<List<NameValuePair>> metadata;

    /**
     * Creates an instance of Solution class.
     */
    public Solution() {
    }

    /**
     * Get the id property: Solution Id.
     * 
     * @return the id value.
     */
    public Double id() {
        return this.id;
    }

    /**
     * Set the id property: Solution Id.
     * 
     * @param id the id value to set.
     * @return the Solution object itself.
     */
    public Solution withId(Double id) {
        this.id = id;
        return this;
    }

    /**
     * Get the displayName property: Display Name of the solution.
     * 
     * @return the displayName value.
     */
    public String displayName() {
        return this.displayName;
    }

    /**
     * Set the displayName property: Display Name of the solution.
     * 
     * @param displayName the displayName value to set.
     * @return the Solution object itself.
     */
    public Solution withDisplayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    /**
     * Get the order property: Order of the solution.
     * 
     * @return the order value.
     */
    public Double order() {
        return this.order;
    }

    /**
     * Set the order property: Order of the solution.
     * 
     * @param order the order value to set.
     * @return the Solution object itself.
     */
    public Solution withOrder(Double order) {
        this.order = order;
        return this;
    }

    /**
     * Get the description property: Description of the solution.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the solution.
     * 
     * @param description the description value to set.
     * @return the Solution object itself.
     */
    public Solution withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the type property: Type of Solution.
     * 
     * @return the type value.
     */
    public SolutionType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of Solution.
     * 
     * @param type the type value to set.
     * @return the Solution object itself.
     */
    public Solution withType(SolutionType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the data property: Solution Data.
     * 
     * @return the data value.
     */
    public List<List<NameValuePair>> data() {
        return this.data;
    }

    /**
     * Set the data property: Solution Data.
     * 
     * @param data the data value to set.
     * @return the Solution object itself.
     */
    public Solution withData(List<List<NameValuePair>> data) {
        this.data = data;
        return this;
    }

    /**
     * Get the metadata property: Solution Metadata.
     * 
     * @return the metadata value.
     */
    public List<List<NameValuePair>> metadata() {
        return this.metadata;
    }

    /**
     * Set the metadata property: Solution Metadata.
     * 
     * @param metadata the metadata value to set.
     * @return the Solution object itself.
     */
    public Solution withMetadata(List<List<NameValuePair>> metadata) {
        this.metadata = metadata;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (data() != null) {
            data().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
        if (metadata() != null) {
            metadata().forEach(e -> e.forEach(e1 -> e1.validate()));
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("id", this.id);
        jsonWriter.writeStringField("displayName", this.displayName);
        jsonWriter.writeNumberField("order", this.order);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeArrayField("data", this.data,
            (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeJson(element1)));
        jsonWriter.writeArrayField("metadata", this.metadata,
            (writer, element) -> writer.writeArray(element, (writer1, element1) -> writer1.writeJson(element1)));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Solution from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Solution if the JsonReader was pointing to an instance of it, or null if it was pointing
     * to JSON null.
     * @throws IOException If an error occurs while reading the Solution.
     */
    public static Solution fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Solution deserializedSolution = new Solution();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSolution.id = reader.getNullable(JsonReader::getDouble);
                } else if ("displayName".equals(fieldName)) {
                    deserializedSolution.displayName = reader.getString();
                } else if ("order".equals(fieldName)) {
                    deserializedSolution.order = reader.getNullable(JsonReader::getDouble);
                } else if ("description".equals(fieldName)) {
                    deserializedSolution.description = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedSolution.type = SolutionType.fromString(reader.getString());
                } else if ("data".equals(fieldName)) {
                    List<List<NameValuePair>> data
                        = reader.readArray(reader1 -> reader1.readArray(reader2 -> NameValuePair.fromJson(reader2)));
                    deserializedSolution.data = data;
                } else if ("metadata".equals(fieldName)) {
                    List<List<NameValuePair>> metadata
                        = reader.readArray(reader1 -> reader1.readArray(reader2 -> NameValuePair.fromJson(reader2)));
                    deserializedSolution.metadata = metadata;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSolution;
        });
    }
}
