// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Defines a unique Support Topic.
 */
@Immutable
public final class SupportTopic implements JsonSerializable<SupportTopic> {
    /*
     * Support Topic Id
     */
    private String id;

    /*
     * Unique resource Id
     */
    private String pesId;

    /**
     * Creates an instance of SupportTopic class.
     */
    public SupportTopic() {
    }

    /**
     * Get the id property: Support Topic Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Get the pesId property: Unique resource Id.
     * 
     * @return the pesId value.
     */
    public String pesId() {
        return this.pesId;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SupportTopic from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SupportTopic if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SupportTopic.
     */
    public static SupportTopic fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SupportTopic deserializedSupportTopic = new SupportTopic();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedSupportTopic.id = reader.getString();
                } else if ("pesId".equals(fieldName)) {
                    deserializedSupportTopic.pesId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSupportTopic;
        });
    }
}
