/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.fluent.models.BackupItemProperties;
import com.azure.resourcemanager.appservice.models.BackupItemStatus;
import com.azure.resourcemanager.appservice.models.DatabaseBackupSetting;
import com.azure.resourcemanager.appservice.models.ProxyOnlyResource;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

public final class BackupItemInner
extends ProxyOnlyResource {
    private BackupItemProperties innerProperties;
    private String type;
    private String name;
    private String id;

    private BackupItemProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public BackupItemInner withKind(String kind) {
        super.withKind(kind);
        return this;
    }

    public Integer backupId() {
        return this.innerProperties() == null ? null : this.innerProperties().backupId();
    }

    public String storageAccountUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().storageAccountUrl();
    }

    public String blobName() {
        return this.innerProperties() == null ? null : this.innerProperties().blobName();
    }

    public String namePropertiesName() {
        return this.innerProperties() == null ? null : this.innerProperties().name();
    }

    public BackupItemStatus status() {
        return this.innerProperties() == null ? null : this.innerProperties().status();
    }

    public Long sizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().sizeInBytes();
    }

    public OffsetDateTime created() {
        return this.innerProperties() == null ? null : this.innerProperties().created();
    }

    public String log() {
        return this.innerProperties() == null ? null : this.innerProperties().log();
    }

    public List<DatabaseBackupSetting> databases() {
        return this.innerProperties() == null ? null : this.innerProperties().databases();
    }

    public Boolean scheduled() {
        return this.innerProperties() == null ? null : this.innerProperties().scheduled();
    }

    public OffsetDateTime lastRestoreTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().lastRestoreTimestamp();
    }

    public OffsetDateTime finishedTimestamp() {
        return this.innerProperties() == null ? null : this.innerProperties().finishedTimestamp();
    }

    public String correlationId() {
        return this.innerProperties() == null ? null : this.innerProperties().correlationId();
    }

    public Long websiteSizeInBytes() {
        return this.innerProperties() == null ? null : this.innerProperties().websiteSizeInBytes();
    }

    @Override
    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static BackupItemInner fromJson(JsonReader jsonReader) throws IOException {
        return (BackupItemInner)((Object)jsonReader.readObject(reader -> {
            BackupItemInner deserializedBackupItemInner = new BackupItemInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedBackupItemInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedBackupItemInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedBackupItemInner.type = reader.getString();
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedBackupItemInner.withKind(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedBackupItemInner.innerProperties = BackupItemProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBackupItemInner;
        }));
    }
}

