// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.HostingEnvironmentProfile;
import com.azure.resourcemanager.appservice.models.KeyVaultSecretStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Certificate resource specific properties.
 */
@Fluent
public final class CertificateProperties implements JsonSerializable<CertificateProperties> {
    /*
     * Certificate password.
     */
    private String password;

    /*
     * Friendly name of the certificate.
     */
    private String friendlyName;

    /*
     * Subject name of the certificate.
     */
    private String subjectName;

    /*
     * Host names the certificate applies to.
     */
    private List<String> hostNames;

    /*
     * Pfx blob.
     */
    private byte[] pfxBlob;

    /*
     * App name.
     */
    private String siteName;

    /*
     * Self link.
     */
    private String selfLink;

    /*
     * Certificate issuer.
     */
    private String issuer;

    /*
     * Certificate issue Date.
     */
    private OffsetDateTime issueDate;

    /*
     * Certificate expiration date.
     */
    private OffsetDateTime expirationDate;

    /*
     * Certificate thumbprint.
     */
    private String thumbprint;

    /*
     * Is the certificate valid?.
     */
    private Boolean valid;

    /*
     * Raw bytes of .cer file
     */
    private byte[] cerBlob;

    /*
     * Public key hash.
     */
    private String publicKeyHash;

    /*
     * Specification for the App Service Environment to use for the certificate.
     */
    private HostingEnvironmentProfile hostingEnvironmentProfile;

    /*
     * Key Vault Csm resource Id.
     */
    private String keyVaultId;

    /*
     * Key Vault secret name.
     */
    private String keyVaultSecretName;

    /*
     * Status of the Key Vault secret.
     */
    private KeyVaultSecretStatus keyVaultSecretStatus;

    /*
     * Resource ID of the associated App Service plan, formatted as:
     * "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
     */
    private String serverFarmId;

    /*
     * CNAME of the certificate to be issued via free certificate
     */
    private String canonicalName;

    /*
     * Method of domain validation for free cert
     */
    private String domainValidationMethod;

    /**
     * Creates an instance of CertificateProperties class.
     */
    public CertificateProperties() {
    }

    /**
     * Get the password property: Certificate password.
     * 
     * @return the password value.
     */
    public String password() {
        return this.password;
    }

    /**
     * Set the password property: Certificate password.
     * 
     * @param password the password value to set.
     * @return the CertificateProperties object itself.
     */
    public CertificateProperties withPassword(String password) {
        this.password = password;
        return this;
    }

    /**
     * Get the friendlyName property: Friendly name of the certificate.
     * 
     * @return the friendlyName value.
     */
    public String friendlyName() {
        return this.friendlyName;
    }

    /**
     * Get the subjectName property: Subject name of the certificate.
     * 
     * @return the subjectName value.
     */
    public String subjectName() {
        return this.subjectName;
    }

    /**
     * Get the hostNames property: Host names the certificate applies to.
     * 
     * @return the hostNames value.
     */
    public List<String> hostNames() {
        return this.hostNames;
    }

    /**
     * Set the hostNames property: Host names the certificate applies to.
     * 
     * @param hostNames the hostNames value to set.
     * @return the CertificateProperties object itself.
     */
    public CertificateProperties withHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    /**
     * Get the pfxBlob property: Pfx blob.
     * 
     * @return the pfxBlob value.
     */
    public byte[] pfxBlob() {
        return CoreUtils.clone(this.pfxBlob);
    }

    /**
     * Set the pfxBlob property: Pfx blob.
     * 
     * @param pfxBlob the pfxBlob value to set.
     * @return the CertificateProperties object itself.
     */
    public CertificateProperties withPfxBlob(byte[] pfxBlob) {
        this.pfxBlob = CoreUtils.clone(pfxBlob);
        return this;
    }

    /**
     * Get the siteName property: App name.
     * 
     * @return the siteName value.
     */
    public String siteName() {
        return this.siteName;
    }

    /**
     * Get the selfLink property: Self link.
     * 
     * @return the selfLink value.
     */
    public String selfLink() {
        return this.selfLink;
    }

    /**
     * Get the issuer property: Certificate issuer.
     * 
     * @return the issuer value.
     */
    public String issuer() {
        return this.issuer;
    }

    /**
     * Get the issueDate property: Certificate issue Date.
     * 
     * @return the issueDate value.
     */
    public OffsetDateTime issueDate() {
        return this.issueDate;
    }

    /**
     * Get the expirationDate property: Certificate expiration date.
     * 
     * @return the expirationDate value.
     */
    public OffsetDateTime expirationDate() {
        return this.expirationDate;
    }

    /**
     * Get the thumbprint property: Certificate thumbprint.
     * 
     * @return the thumbprint value.
     */
    public String thumbprint() {
        return this.thumbprint;
    }

    /**
     * Get the valid property: Is the certificate valid?.
     * 
     * @return the valid value.
     */
    public Boolean valid() {
        return this.valid;
    }

    /**
     * Get the cerBlob property: Raw bytes of .cer file.
     * 
     * @return the cerBlob value.
     */
    public byte[] cerBlob() {
        return CoreUtils.clone(this.cerBlob);
    }

    /**
     * Get the publicKeyHash property: Public key hash.
     * 
     * @return the publicKeyHash value.
     */
    public String publicKeyHash() {
        return this.publicKeyHash;
    }

    /**
     * Get the hostingEnvironmentProfile property: Specification for the App Service Environment to use for the
     * certificate.
     * 
     * @return the hostingEnvironmentProfile value.
     */
    public HostingEnvironmentProfile hostingEnvironmentProfile() {
        return this.hostingEnvironmentProfile;
    }

    /**
     * Get the keyVaultId property: Key Vault Csm resource Id.
     * 
     * @return the keyVaultId value.
     */
    public String keyVaultId() {
        return this.keyVaultId;
    }

    /**
     * Set the keyVaultId property: Key Vault Csm resource Id.
     * 
     * @param keyVaultId the keyVaultId value to set.
     * @return the CertificateProperties object itself.
     */
    public CertificateProperties withKeyVaultId(String keyVaultId) {
        this.keyVaultId = keyVaultId;
        return this;
    }

    /**
     * Get the keyVaultSecretName property: Key Vault secret name.
     * 
     * @return the keyVaultSecretName value.
     */
    public String keyVaultSecretName() {
        return this.keyVaultSecretName;
    }

    /**
     * Set the keyVaultSecretName property: Key Vault secret name.
     * 
     * @param keyVaultSecretName the keyVaultSecretName value to set.
     * @return the CertificateProperties object itself.
     */
    public CertificateProperties withKeyVaultSecretName(String keyVaultSecretName) {
        this.keyVaultSecretName = keyVaultSecretName;
        return this;
    }

    /**
     * Get the keyVaultSecretStatus property: Status of the Key Vault secret.
     * 
     * @return the keyVaultSecretStatus value.
     */
    public KeyVaultSecretStatus keyVaultSecretStatus() {
        return this.keyVaultSecretStatus;
    }

    /**
     * Get the serverFarmId property: Resource ID of the associated App Service plan, formatted as:
     * "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
     * 
     * @return the serverFarmId value.
     */
    public String serverFarmId() {
        return this.serverFarmId;
    }

    /**
     * Set the serverFarmId property: Resource ID of the associated App Service plan, formatted as:
     * "/subscriptions/{subscriptionID}/resourceGroups/{groupName}/providers/Microsoft.Web/serverfarms/{appServicePlanName}".
     * 
     * @param serverFarmId the serverFarmId value to set.
     * @return the CertificateProperties object itself.
     */
    public CertificateProperties withServerFarmId(String serverFarmId) {
        this.serverFarmId = serverFarmId;
        return this;
    }

    /**
     * Get the canonicalName property: CNAME of the certificate to be issued via free certificate.
     * 
     * @return the canonicalName value.
     */
    public String canonicalName() {
        return this.canonicalName;
    }

    /**
     * Set the canonicalName property: CNAME of the certificate to be issued via free certificate.
     * 
     * @param canonicalName the canonicalName value to set.
     * @return the CertificateProperties object itself.
     */
    public CertificateProperties withCanonicalName(String canonicalName) {
        this.canonicalName = canonicalName;
        return this;
    }

    /**
     * Get the domainValidationMethod property: Method of domain validation for free cert.
     * 
     * @return the domainValidationMethod value.
     */
    public String domainValidationMethod() {
        return this.domainValidationMethod;
    }

    /**
     * Set the domainValidationMethod property: Method of domain validation for free cert.
     * 
     * @param domainValidationMethod the domainValidationMethod value to set.
     * @return the CertificateProperties object itself.
     */
    public CertificateProperties withDomainValidationMethod(String domainValidationMethod) {
        this.domainValidationMethod = domainValidationMethod;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hostingEnvironmentProfile() != null) {
            hostingEnvironmentProfile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("password", this.password);
        jsonWriter.writeArrayField("hostNames", this.hostNames, (writer, element) -> writer.writeString(element));
        jsonWriter.writeBinaryField("pfxBlob", this.pfxBlob);
        jsonWriter.writeStringField("keyVaultId", this.keyVaultId);
        jsonWriter.writeStringField("keyVaultSecretName", this.keyVaultSecretName);
        jsonWriter.writeStringField("serverFarmId", this.serverFarmId);
        jsonWriter.writeStringField("canonicalName", this.canonicalName);
        jsonWriter.writeStringField("domainValidationMethod", this.domainValidationMethod);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CertificateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CertificateProperties if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CertificateProperties.
     */
    public static CertificateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CertificateProperties deserializedCertificateProperties = new CertificateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("password".equals(fieldName)) {
                    deserializedCertificateProperties.password = reader.getString();
                } else if ("friendlyName".equals(fieldName)) {
                    deserializedCertificateProperties.friendlyName = reader.getString();
                } else if ("subjectName".equals(fieldName)) {
                    deserializedCertificateProperties.subjectName = reader.getString();
                } else if ("hostNames".equals(fieldName)) {
                    List<String> hostNames = reader.readArray(reader1 -> reader1.getString());
                    deserializedCertificateProperties.hostNames = hostNames;
                } else if ("pfxBlob".equals(fieldName)) {
                    deserializedCertificateProperties.pfxBlob = reader.getBinary();
                } else if ("siteName".equals(fieldName)) {
                    deserializedCertificateProperties.siteName = reader.getString();
                } else if ("selfLink".equals(fieldName)) {
                    deserializedCertificateProperties.selfLink = reader.getString();
                } else if ("issuer".equals(fieldName)) {
                    deserializedCertificateProperties.issuer = reader.getString();
                } else if ("issueDate".equals(fieldName)) {
                    deserializedCertificateProperties.issueDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("expirationDate".equals(fieldName)) {
                    deserializedCertificateProperties.expirationDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("thumbprint".equals(fieldName)) {
                    deserializedCertificateProperties.thumbprint = reader.getString();
                } else if ("valid".equals(fieldName)) {
                    deserializedCertificateProperties.valid = reader.getNullable(JsonReader::getBoolean);
                } else if ("cerBlob".equals(fieldName)) {
                    deserializedCertificateProperties.cerBlob = reader.getBinary();
                } else if ("publicKeyHash".equals(fieldName)) {
                    deserializedCertificateProperties.publicKeyHash = reader.getString();
                } else if ("hostingEnvironmentProfile".equals(fieldName)) {
                    deserializedCertificateProperties.hostingEnvironmentProfile
                        = HostingEnvironmentProfile.fromJson(reader);
                } else if ("keyVaultId".equals(fieldName)) {
                    deserializedCertificateProperties.keyVaultId = reader.getString();
                } else if ("keyVaultSecretName".equals(fieldName)) {
                    deserializedCertificateProperties.keyVaultSecretName = reader.getString();
                } else if ("keyVaultSecretStatus".equals(fieldName)) {
                    deserializedCertificateProperties.keyVaultSecretStatus
                        = KeyVaultSecretStatus.fromString(reader.getString());
                } else if ("serverFarmId".equals(fieldName)) {
                    deserializedCertificateProperties.serverFarmId = reader.getString();
                } else if ("canonicalName".equals(fieldName)) {
                    deserializedCertificateProperties.canonicalName = reader.getString();
                } else if ("domainValidationMethod".equals(fieldName)) {
                    deserializedCertificateProperties.domainValidationMethod = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCertificateProperties;
        });
    }
}
