// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContainerInfo;
import com.azure.resourcemanager.appservice.models.SiteRuntimeState;
import java.io.IOException;
import java.util.Map;

/**
 * WebSiteInstanceStatus resource specific properties.
 */
@Fluent
public final class WebSiteInstanceStatusProperties implements JsonSerializable<WebSiteInstanceStatusProperties> {
    /*
     * The state property.
     */
    private SiteRuntimeState state;

    /*
     * Link to the GetStatusApi in Kudu
     */
    private String statusUrl;

    /*
     * Link to the Diagnose and Solve Portal
     */
    private String detectorUrl;

    /*
     * Link to the console to web app instance
     */
    private String consoleUrl;

    /*
     * Link to the console to web app instance
     */
    private String healthCheckUrl;

    /*
     * Dictionary of <ContainerInfo>
     */
    private Map<String, ContainerInfo> containers;

    /*
     * The physical zone that the instance is in
     */
    private String physicalZone;

    /**
     * Creates an instance of WebSiteInstanceStatusProperties class.
     */
    public WebSiteInstanceStatusProperties() {
    }

    /**
     * Get the state property: The state property.
     * 
     * @return the state value.
     */
    public SiteRuntimeState state() {
        return this.state;
    }

    /**
     * Set the state property: The state property.
     * 
     * @param state the state value to set.
     * @return the WebSiteInstanceStatusProperties object itself.
     */
    public WebSiteInstanceStatusProperties withState(SiteRuntimeState state) {
        this.state = state;
        return this;
    }

    /**
     * Get the statusUrl property: Link to the GetStatusApi in Kudu.
     * 
     * @return the statusUrl value.
     */
    public String statusUrl() {
        return this.statusUrl;
    }

    /**
     * Set the statusUrl property: Link to the GetStatusApi in Kudu.
     * 
     * @param statusUrl the statusUrl value to set.
     * @return the WebSiteInstanceStatusProperties object itself.
     */
    public WebSiteInstanceStatusProperties withStatusUrl(String statusUrl) {
        this.statusUrl = statusUrl;
        return this;
    }

    /**
     * Get the detectorUrl property: Link to the Diagnose and Solve Portal.
     * 
     * @return the detectorUrl value.
     */
    public String detectorUrl() {
        return this.detectorUrl;
    }

    /**
     * Set the detectorUrl property: Link to the Diagnose and Solve Portal.
     * 
     * @param detectorUrl the detectorUrl value to set.
     * @return the WebSiteInstanceStatusProperties object itself.
     */
    public WebSiteInstanceStatusProperties withDetectorUrl(String detectorUrl) {
        this.detectorUrl = detectorUrl;
        return this;
    }

    /**
     * Get the consoleUrl property: Link to the console to web app instance.
     * 
     * @return the consoleUrl value.
     */
    public String consoleUrl() {
        return this.consoleUrl;
    }

    /**
     * Set the consoleUrl property: Link to the console to web app instance.
     * 
     * @param consoleUrl the consoleUrl value to set.
     * @return the WebSiteInstanceStatusProperties object itself.
     */
    public WebSiteInstanceStatusProperties withConsoleUrl(String consoleUrl) {
        this.consoleUrl = consoleUrl;
        return this;
    }

    /**
     * Get the healthCheckUrl property: Link to the console to web app instance.
     * 
     * @return the healthCheckUrl value.
     */
    public String healthCheckUrl() {
        return this.healthCheckUrl;
    }

    /**
     * Set the healthCheckUrl property: Link to the console to web app instance.
     * 
     * @param healthCheckUrl the healthCheckUrl value to set.
     * @return the WebSiteInstanceStatusProperties object itself.
     */
    public WebSiteInstanceStatusProperties withHealthCheckUrl(String healthCheckUrl) {
        this.healthCheckUrl = healthCheckUrl;
        return this;
    }

    /**
     * Get the containers property: Dictionary of &lt;ContainerInfo&gt;.
     * 
     * @return the containers value.
     */
    public Map<String, ContainerInfo> containers() {
        return this.containers;
    }

    /**
     * Set the containers property: Dictionary of &lt;ContainerInfo&gt;.
     * 
     * @param containers the containers value to set.
     * @return the WebSiteInstanceStatusProperties object itself.
     */
    public WebSiteInstanceStatusProperties withContainers(Map<String, ContainerInfo> containers) {
        this.containers = containers;
        return this;
    }

    /**
     * Get the physicalZone property: The physical zone that the instance is in.
     * 
     * @return the physicalZone value.
     */
    public String physicalZone() {
        return this.physicalZone;
    }

    /**
     * Set the physicalZone property: The physical zone that the instance is in.
     * 
     * @param physicalZone the physicalZone value to set.
     * @return the WebSiteInstanceStatusProperties object itself.
     */
    public WebSiteInstanceStatusProperties withPhysicalZone(String physicalZone) {
        this.physicalZone = physicalZone;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (containers() != null) {
            containers().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("state", this.state == null ? null : this.state.toString());
        jsonWriter.writeStringField("statusUrl", this.statusUrl);
        jsonWriter.writeStringField("detectorUrl", this.detectorUrl);
        jsonWriter.writeStringField("consoleUrl", this.consoleUrl);
        jsonWriter.writeStringField("healthCheckUrl", this.healthCheckUrl);
        jsonWriter.writeMapField("containers", this.containers, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("physicalZone", this.physicalZone);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WebSiteInstanceStatusProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WebSiteInstanceStatusProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WebSiteInstanceStatusProperties.
     */
    public static WebSiteInstanceStatusProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebSiteInstanceStatusProperties deserializedWebSiteInstanceStatusProperties
                = new WebSiteInstanceStatusProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("state".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.state = SiteRuntimeState.fromString(reader.getString());
                } else if ("statusUrl".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.statusUrl = reader.getString();
                } else if ("detectorUrl".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.detectorUrl = reader.getString();
                } else if ("consoleUrl".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.consoleUrl = reader.getString();
                } else if ("healthCheckUrl".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.healthCheckUrl = reader.getString();
                } else if ("containers".equals(fieldName)) {
                    Map<String, ContainerInfo> containers = reader.readMap(reader1 -> ContainerInfo.fromJson(reader1));
                    deserializedWebSiteInstanceStatusProperties.containers = containers;
                } else if ("physicalZone".equals(fieldName)) {
                    deserializedWebSiteInstanceStatusProperties.physicalZone = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWebSiteInstanceStatusProperties;
        });
    }
}
