// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.appservice.models.ContentLink;
import com.azure.resourcemanager.appservice.models.Correlation;
import com.azure.resourcemanager.appservice.models.ResourceReference;
import com.azure.resourcemanager.appservice.models.WorkflowStatus;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * The workflow trigger history properties.
 */
@Fluent
public final class WorkflowTriggerHistoryProperties implements JsonSerializable<WorkflowTriggerHistoryProperties> {
    /*
     * Gets the start time.
     */
    private OffsetDateTime startTime;

    /*
     * Gets the end time.
     */
    private OffsetDateTime endTime;

    /*
     * The scheduled time.
     */
    private OffsetDateTime scheduledTime;

    /*
     * Gets the status.
     */
    private WorkflowStatus status;

    /*
     * Gets the code.
     */
    private String code;

    /*
     * Gets the error.
     */
    private Object error;

    /*
     * Gets the tracking id.
     */
    private String trackingId;

    /*
     * The run correlation.
     */
    private Correlation correlation;

    /*
     * Gets the link to input parameters.
     */
    private ContentLink inputsLink;

    /*
     * Gets the link to output parameters.
     */
    private ContentLink outputsLink;

    /*
     * The value indicating whether trigger was fired.
     */
    private Boolean fired;

    /*
     * Gets the reference to workflow run.
     */
    private ResourceReference run;

    /**
     * Creates an instance of WorkflowTriggerHistoryProperties class.
     */
    public WorkflowTriggerHistoryProperties() {
    }

    /**
     * Get the startTime property: Gets the start time.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the endTime property: Gets the end time.
     * 
     * @return the endTime value.
     */
    public OffsetDateTime endTime() {
        return this.endTime;
    }

    /**
     * Get the scheduledTime property: The scheduled time.
     * 
     * @return the scheduledTime value.
     */
    public OffsetDateTime scheduledTime() {
        return this.scheduledTime;
    }

    /**
     * Get the status property: Gets the status.
     * 
     * @return the status value.
     */
    public WorkflowStatus status() {
        return this.status;
    }

    /**
     * Get the code property: Gets the code.
     * 
     * @return the code value.
     */
    public String code() {
        return this.code;
    }

    /**
     * Get the error property: Gets the error.
     * 
     * @return the error value.
     */
    public Object error() {
        return this.error;
    }

    /**
     * Get the trackingId property: Gets the tracking id.
     * 
     * @return the trackingId value.
     */
    public String trackingId() {
        return this.trackingId;
    }

    /**
     * Get the correlation property: The run correlation.
     * 
     * @return the correlation value.
     */
    public Correlation correlation() {
        return this.correlation;
    }

    /**
     * Set the correlation property: The run correlation.
     * 
     * @param correlation the correlation value to set.
     * @return the WorkflowTriggerHistoryProperties object itself.
     */
    public WorkflowTriggerHistoryProperties withCorrelation(Correlation correlation) {
        this.correlation = correlation;
        return this;
    }

    /**
     * Get the inputsLink property: Gets the link to input parameters.
     * 
     * @return the inputsLink value.
     */
    public ContentLink inputsLink() {
        return this.inputsLink;
    }

    /**
     * Get the outputsLink property: Gets the link to output parameters.
     * 
     * @return the outputsLink value.
     */
    public ContentLink outputsLink() {
        return this.outputsLink;
    }

    /**
     * Get the fired property: The value indicating whether trigger was fired.
     * 
     * @return the fired value.
     */
    public Boolean fired() {
        return this.fired;
    }

    /**
     * Get the run property: Gets the reference to workflow run.
     * 
     * @return the run value.
     */
    public ResourceReference run() {
        return this.run;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (correlation() != null) {
            correlation().validate();
        }
        if (inputsLink() != null) {
            inputsLink().validate();
        }
        if (outputsLink() != null) {
            outputsLink().validate();
        }
        if (run() != null) {
            run().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("correlation", this.correlation);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of WorkflowTriggerHistoryProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of WorkflowTriggerHistoryProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the WorkflowTriggerHistoryProperties.
     */
    public static WorkflowTriggerHistoryProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WorkflowTriggerHistoryProperties deserializedWorkflowTriggerHistoryProperties
                = new WorkflowTriggerHistoryProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("startTime".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("endTime".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.endTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("scheduledTime".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.scheduledTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("status".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.status = WorkflowStatus.fromString(reader.getString());
                } else if ("code".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.code = reader.getString();
                } else if ("error".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.error = reader.readUntyped();
                } else if ("trackingId".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.trackingId = reader.getString();
                } else if ("correlation".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.correlation = Correlation.fromJson(reader);
                } else if ("inputsLink".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.inputsLink = ContentLink.fromJson(reader);
                } else if ("outputsLink".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.outputsLink = ContentLink.fromJson(reader);
                } else if ("fired".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.fired = reader.getNullable(JsonReader::getBoolean);
                } else if ("run".equals(fieldName)) {
                    deserializedWorkflowTriggerHistoryProperties.run = ResourceReference.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedWorkflowTriggerHistoryProperties;
        });
    }
}
