// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.appservice.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ContainerMemoryStatistics model.
 */
@Fluent
public final class ContainerMemoryStatistics implements JsonSerializable<ContainerMemoryStatistics> {
    /*
     * The usage property.
     */
    private Long usage;

    /*
     * The maxUsage property.
     */
    private Long maxUsage;

    /*
     * The limit property.
     */
    private Long limit;

    /**
     * Creates an instance of ContainerMemoryStatistics class.
     */
    public ContainerMemoryStatistics() {
    }

    /**
     * Get the usage property: The usage property.
     * 
     * @return the usage value.
     */
    public Long usage() {
        return this.usage;
    }

    /**
     * Set the usage property: The usage property.
     * 
     * @param usage the usage value to set.
     * @return the ContainerMemoryStatistics object itself.
     */
    public ContainerMemoryStatistics withUsage(Long usage) {
        this.usage = usage;
        return this;
    }

    /**
     * Get the maxUsage property: The maxUsage property.
     * 
     * @return the maxUsage value.
     */
    public Long maxUsage() {
        return this.maxUsage;
    }

    /**
     * Set the maxUsage property: The maxUsage property.
     * 
     * @param maxUsage the maxUsage value to set.
     * @return the ContainerMemoryStatistics object itself.
     */
    public ContainerMemoryStatistics withMaxUsage(Long maxUsage) {
        this.maxUsage = maxUsage;
        return this;
    }

    /**
     * Get the limit property: The limit property.
     * 
     * @return the limit value.
     */
    public Long limit() {
        return this.limit;
    }

    /**
     * Set the limit property: The limit property.
     * 
     * @param limit the limit value to set.
     * @return the ContainerMemoryStatistics object itself.
     */
    public ContainerMemoryStatistics withLimit(Long limit) {
        this.limit = limit;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("usage", this.usage);
        jsonWriter.writeNumberField("maxUsage", this.maxUsage);
        jsonWriter.writeNumberField("limit", this.limit);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ContainerMemoryStatistics from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ContainerMemoryStatistics if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ContainerMemoryStatistics.
     */
    public static ContainerMemoryStatistics fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerMemoryStatistics deserializedContainerMemoryStatistics = new ContainerMemoryStatistics();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("usage".equals(fieldName)) {
                    deserializedContainerMemoryStatistics.usage = reader.getNullable(JsonReader::getLong);
                } else if ("maxUsage".equals(fieldName)) {
                    deserializedContainerMemoryStatistics.maxUsage = reader.getNullable(JsonReader::getLong);
                } else if ("limit".equals(fieldName)) {
                    deserializedContainerMemoryStatistics.limit = reader.getNullable(JsonReader::getLong);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedContainerMemoryStatistics;
        });
    }
}
